/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithErrorHandlerRemoveTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAdviceErrorHandlerRemove() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("foo"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.getOriginalRoute().errorHandler((ErrorHandlerFactory)this.noErrorHandler());
            }
        });
        this.context.start();
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:foo", (Object)"Hello World"), (String)"Should throw exception");
        Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceErrorHandlerReplace() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead2").expectedMessageCount(1);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("foo"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveAddFirst().onException(Exception.class).handled(true).to("mock:dead2");
            }
        });
        this.context.start();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:c")).to("mock:d");
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead")).to("mock:a")).throwException((Exception)new IllegalArgumentException("Forced"))).to("mock:b");
            }
        };
    }
}

