/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithCBRTest
extends ContextTestSupport {
    @Test
    public void testAdviceCBR() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveById("foo").after().to("mock:foo2");
                this.weaveById("bar").after().to("mock:bar2");
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo2").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:bar2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:baz").expectedBodiesReceived(new Object[]{"Hi World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "bar", (Object)"123");
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceToStringCBR() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveByToString("To[mock:foo]").after().to("mock:foo2");
                this.weaveByToString("To[mock:bar]").after().to("mock:bar2");
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo2").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:bar2").expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:baz").expectedBodiesReceived(new Object[]{"Hi World"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "bar", (Object)"123");
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)this.header("foo")).to("mock:foo")).id("foo")).when((Predicate)this.header("bar")).to("mock:bar")).id("bar")).otherwise().to("mock:baz")).id("baz");
            }
        };
    }
}

