/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.verifier;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.OptionsGroup;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResultErrorHelperTest {
    final OptionsGroup[] groups = new OptionsGroup[]{OptionsGroup.withName((String)"optionA").options(new String[]{"param1", "param2", "!param3"}), OptionsGroup.withName((String)"optionB").options(new String[]{"param1", "!param2", "param3"}), OptionsGroup.withName((String)"optionC").options(new String[]{"!param1", "!param2", "param4"})};

    @Test
    public void shouldValidateCorrectParameters() {
        Assertions.assertTrue((boolean)ResultErrorHelper.requiresAny(ResultErrorHelperTest.map("param1", "param2"), (OptionsGroup[])this.groups).isEmpty());
        Assertions.assertTrue((boolean)ResultErrorHelper.requiresAny(ResultErrorHelperTest.map("param1", "param3"), (OptionsGroup[])this.groups).isEmpty());
        Assertions.assertTrue((boolean)ResultErrorHelper.requiresAny(ResultErrorHelperTest.map("param4"), (OptionsGroup[])this.groups).isEmpty());
    }

    @Test
    public void shouldValidateParameterExclusions() {
        List results = ResultErrorHelper.requiresAny(ResultErrorHelperTest.map("param1", "param2", "param3"), (OptionsGroup[])this.groups);
        Assertions.assertEquals((int)3, (int)results.size());
        ComponentVerifierExtension.VerificationError param3Error = (ComponentVerifierExtension.VerificationError)results.get(0);
        Assertions.assertEquals((Object)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION, (Object)param3Error.getCode());
        Assertions.assertEquals((Object)"optionA", (Object)param3Error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_NAME));
        Assertions.assertEquals((Object)"param1,param2,param3", (Object)param3Error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_OPTIONS));
        ComponentVerifierExtension.VerificationError param2Error = (ComponentVerifierExtension.VerificationError)results.get(1);
        Assertions.assertEquals((Object)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION, (Object)param2Error.getCode());
        Assertions.assertEquals((Object)"optionB", (Object)param2Error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_NAME));
        Assertions.assertEquals((Object)"param1,param2,param3", (Object)param2Error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_OPTIONS));
        ComponentVerifierExtension.VerificationError param4Error = (ComponentVerifierExtension.VerificationError)results.get(2);
        Assertions.assertEquals((Object)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_GROUP_COMBINATION, (Object)param4Error.getCode());
        Assertions.assertEquals((Object)"optionC", (Object)param4Error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_NAME));
        Assertions.assertEquals((Object)"param1,param2,param4", (Object)param4Error.getDetail((ComponentVerifierExtension.VerificationError.Attribute)ComponentVerifierExtension.VerificationError.GroupAttribute.GROUP_OPTIONS));
    }

    static Map<String, Object> map(String ... params) {
        return Arrays.stream(params).collect(Collectors.toMap(e -> e, e -> "value"));
    }
}

