/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.verifier;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultComponentVerifierTest
extends ContextTestSupport {
    private ComponentVerifierExtension verifier;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.verifier = new TestVerifier();
    }

    @Test
    public void testParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("timerName", "dummy");
        parameters.put("period", "1s");
        ComponentVerifierExtension.Result result = this.verifier.verify(ComponentVerifierExtension.Scope.PARAMETERS, parameters);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.OK, (Object)result.getStatus());
    }

    @Test
    public void testParametersWithMissingMandatoryOptions() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("period", "1s");
        ComponentVerifierExtension.Result result = this.verifier.verify(ComponentVerifierExtension.Scope.PARAMETERS, parameters);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.ERROR, (Object)result.getStatus());
        Assertions.assertEquals((int)1, (int)result.getErrors().size());
        Assertions.assertEquals((Object)ComponentVerifierExtension.VerificationError.StandardCode.MISSING_PARAMETER, (Object)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getCode());
        Assertions.assertTrue((boolean)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getParameterKeys().contains("timerName"));
    }

    @Test
    public void testParametersWithWrongOptions() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("timerName", "dummy");
        parameters.put("period", "1s");
        parameters.put("fixedRate", "wrong");
        ComponentVerifierExtension.Result result = this.verifier.verify(ComponentVerifierExtension.Scope.PARAMETERS, parameters);
        Assertions.assertEquals((Object)ComponentVerifierExtension.Result.Status.ERROR, (Object)result.getStatus());
        Assertions.assertEquals((int)1, (int)result.getErrors().size());
        Assertions.assertEquals((Object)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE, (Object)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getCode());
        Assertions.assertEquals((Object)"fixedRate has wrong value (wrong)", (Object)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getDescription());
        Assertions.assertTrue((boolean)((ComponentVerifierExtension.VerificationError)result.getErrors().get(0)).getParameterKeys().contains("fixedRate"));
    }

    private class TestVerifier
    extends DefaultComponentVerifierExtension {
        public TestVerifier() {
            super("timer", (CamelContext)DefaultComponentVerifierTest.this.context);
        }
    }
}

