/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.scheduler.SchedulerConsumer;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SchedulerConsumerHealthCheckTest {
    private static final String TEST_ROUTE_ID = "Test-Route";

    @Test
    public void testShouldBeUP() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("scheduler:foo?initialDelay=5000").id(SchedulerConsumerHealthCheckTest.TEST_ROUTE_ID)).log("Message");
            }
        });
        context.start();
        Route route = context.getRoute(TEST_ROUTE_ID);
        SchedulerConsumer consumer = (SchedulerConsumer)route.getConsumer();
        HealthCheck.Result result = consumer.getHealthCheck().call();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)result.getState());
        context.stop();
    }
}

