/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collections;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.health.RouteHealthCheck;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteHealthCheckTest {
    private static final String TEST_ROUTE_ID = "Test-Route";

    @Test
    public void testDoCallDoesNotHaveNPEWhenJmxDisabled() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:input").id(RouteHealthCheckTest.TEST_ROUTE_ID)).log("Message");
            }
        });
        context.start();
        Route route = context.getRoute(TEST_ROUTE_ID);
        RouteHealthCheck healthCheck = new RouteHealthCheck(route);
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)healthCheck);
        healthCheck.doCall(builder, Collections.emptyMap());
        context.stop();
    }

    @Test
    public void testHealthCheckIsUpWhenRouteIsNotAutoStartup() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:input").id(RouteHealthCheckTest.TEST_ROUTE_ID)).autoStartup(false).log("Message");
            }
        });
        context.start();
        Route route = context.getRoute(TEST_ROUTE_ID);
        RouteHealthCheck healthCheck = new RouteHealthCheck(route);
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)healthCheck);
        healthCheck.doCall(builder, Collections.emptyMap());
        HealthCheck.Result result = builder.build();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)result.getState());
        context.stop();
    }
}

