/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.impl.health.DefaultHealthCheckRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReadinessAndLivenessTest {
    @Test
    public void testLiveAndReady() {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        context.getRegistry().bind("check1", (Object)new MyReadyCheck("G1", "1"));
        context.getRegistry().bind("check2", (Object)new MyLiveCheck("G1", "2"));
        context.start();
        registry.start();
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)2, (int)checks.size());
        Collection results = HealthCheckHelper.invokeReadiness((CamelContext)context);
        Assertions.assertEquals((int)1, (int)results.size());
        HealthCheck.Result result = (HealthCheck.Result)results.iterator().next();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)result.getState());
        Assertions.assertFalse((boolean)result.getCheck().isLiveness());
        Assertions.assertTrue((boolean)result.getCheck().isReadiness());
        Assertions.assertInstanceOf(MyReadyCheck.class, (Object)result.getCheck());
        results = HealthCheckHelper.invokeLiveness((CamelContext)context);
        Assertions.assertEquals((int)1, (int)results.size());
        result = (HealthCheck.Result)results.iterator().next();
        Assertions.assertEquals((Object)HealthCheck.State.DOWN, (Object)result.getState());
        Assertions.assertTrue((boolean)result.getCheck().isLiveness());
        Assertions.assertFalse((boolean)result.getCheck().isReadiness());
        Assertions.assertInstanceOf(MyLiveCheck.class, (Object)result.getCheck());
    }

    @Test
    public void testAll() {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        context.getRegistry().bind("check1", (Object)new MyAllCheck("G1", "1"));
        context.start();
        registry.start();
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)1, (int)checks.size());
        Collection results = HealthCheckHelper.invokeReadiness((CamelContext)context);
        Assertions.assertEquals((int)1, (int)results.size());
        HealthCheck.Result result = (HealthCheck.Result)results.iterator().next();
        Assertions.assertEquals((Object)HealthCheck.State.DOWN, (Object)result.getState());
        Assertions.assertEquals((Object)"READINESS", result.getMessage().get());
        Assertions.assertTrue((boolean)result.getCheck().isLiveness());
        Assertions.assertTrue((boolean)result.getCheck().isReadiness());
        Assertions.assertInstanceOf(MyAllCheck.class, (Object)result.getCheck());
        results = HealthCheckHelper.invokeLiveness((CamelContext)context);
        Assertions.assertEquals((int)1, (int)results.size());
        result = (HealthCheck.Result)results.iterator().next();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)result.getState());
        Assertions.assertTrue((boolean)result.getCheck().isLiveness());
        Assertions.assertTrue((boolean)result.getCheck().isReadiness());
        Assertions.assertEquals((Object)"LIVENESS", result.getMessage().get());
        Assertions.assertInstanceOf(MyAllCheck.class, (Object)result.getCheck());
    }

    private static class MyReadyCheck
    extends AbstractHealthCheck
    implements CamelContextAware {
        protected MyReadyCheck(String group, String id) {
            super(group, id);
        }

        public boolean isReadiness() {
            return true;
        }

        public boolean isLiveness() {
            return false;
        }

        public void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            builder.up();
        }
    }

    private static class MyLiveCheck
    extends AbstractHealthCheck
    implements CamelContextAware {
        protected MyLiveCheck(String group, String id) {
            super(group, id);
        }

        public boolean isReadiness() {
            return false;
        }

        public boolean isLiveness() {
            return true;
        }

        public void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            builder.down();
        }
    }

    private static class MyAllCheck
    extends AbstractHealthCheck
    implements CamelContextAware {
        protected MyAllCheck(String group, String id) {
            super(group, id);
        }

        public boolean isReadiness() {
            return true;
        }

        public boolean isLiveness() {
            return true;
        }

        public void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            String k = options.get("check.kind").toString();
            builder.message(k);
            if ("READINESS".equals(k)) {
                builder.down();
            } else {
                builder.up();
            }
        }
    }
}

