/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MyFooHealthCheckTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testMyFoo() {
        this.context.start();
        HealthCheck hc = PluginHelper.getHealthCheckResolver((CamelContext)this.context).resolveHealthCheck("myfoo");
        Assertions.assertNotNull((Object)hc);
        Assertions.assertEquals((Object)"acme", (Object)hc.getGroup());
        Assertions.assertEquals((Object)"myfoo", (Object)hc.getId());
        HealthCheck.Result r = hc.call();
        Assertions.assertEquals((Object)HealthCheck.State.DOWN, (Object)r.getState());
        Assertions.assertEquals((Object)"Chaos Monkey was here", r.getMessage().get());
    }

    @Test
    public void testAddToRegistry() {
        this.context.start();
        HealthCheck hc = PluginHelper.getHealthCheckResolver((CamelContext)this.context).resolveHealthCheck("myfoo");
        Assertions.assertNotNull((Object)hc);
        HealthCheckRegistry hcr = (HealthCheckRegistry)this.context.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        hcr.register((Object)hc);
        Collection col = HealthCheckHelper.invoke((CamelContext)this.context);
        Assertions.assertEquals((int)1, (int)col.size());
        HealthCheck.Result r = (HealthCheck.Result)col.iterator().next();
        Assertions.assertEquals((Object)HealthCheck.State.DOWN, (Object)r.getState());
        Assertions.assertEquals((Object)"Chaos Monkey was here", r.getMessage().get());
    }
}

