/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HealthCheckTest {
    @Test
    public void testCheck() {
        DefaultCamelContext context = new DefaultCamelContext();
        MyHealthCheck check = new MyHealthCheck();
        check.setCamelContext((CamelContext)context);
        check.setState(HealthCheck.State.UP);
        check.setEnabled(false);
        HealthCheck.Result result = check.call();
        Assertions.assertEquals((Object)HealthCheck.State.UNKNOWN, (Object)result.getState());
        Assertions.assertTrue((boolean)result.getMessage().isPresent());
        Assertions.assertEquals((Object)"Disabled", result.getMessage().get());
        Assertions.assertEquals((Object)false, result.getDetails().get("check.enabled"));
        check.setEnabled(true);
        result = check.call();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)result.getState());
        Assertions.assertFalse((boolean)result.getMessage().isPresent());
        Assertions.assertFalse((boolean)result.getDetails().containsKey("check.enabled"));
    }

    private static class MyHealthCheck
    extends AbstractHealthCheck {
        private HealthCheck.State state = HealthCheck.State.UP;

        MyHealthCheck() {
            super("my");
        }

        public void setState(HealthCheck.State state) {
            this.state = state;
        }

        public HealthCheck.State getState() {
            return this.state;
        }

        public void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            builder.state(this.state);
        }
    }
}

