/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.health.HealthCheckResultStrategy;
import org.apache.camel.support.PluginHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HealthCheckResultStrategyTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testMyFoo() {
        this.context.getRegistry().bind("myStrategy", (Object)new MyResultStrategy());
        this.context.start();
        HealthCheck hc = PluginHelper.getHealthCheckResolver((CamelContext)this.context).resolveHealthCheck("myfoo");
        Assertions.assertNotNull((Object)hc);
        Assertions.assertEquals((Object)"acme", (Object)hc.getGroup());
        Assertions.assertEquals((Object)"myfoo", (Object)hc.getId());
        HealthCheck.Result r = hc.call();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)r.getState());
        Assertions.assertEquals((Object)"I changed this", r.getMessage().get());
    }

    @Test
    public void testAddToRegistry() {
        this.context.getRegistry().bind("myStrategy", (Object)new MyResultStrategy());
        this.context.start();
        HealthCheck hc = PluginHelper.getHealthCheckResolver((CamelContext)this.context).resolveHealthCheck("myfoo");
        Assertions.assertNotNull((Object)hc);
        HealthCheckRegistry hcr = (HealthCheckRegistry)this.context.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        hcr.register((Object)hc);
        Collection col = HealthCheckHelper.invoke((CamelContext)this.context);
        Assertions.assertEquals((int)1, (int)col.size());
        HealthCheck.Result r = (HealthCheck.Result)col.iterator().next();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)r.getState());
        Assertions.assertEquals((Object)"I changed this", r.getMessage().get());
    }

    private static class MyResultStrategy
    implements HealthCheckResultStrategy {
        private MyResultStrategy() {
        }

        public void processResult(HealthCheck check, Map<String, Object> options, HealthCheckResultBuilder builder) {
            builder.up();
            builder.message("I changed this");
        }
    }
}

