/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.impl.health.ContextHealthCheck;
import org.apache.camel.impl.health.DefaultHealthCheckRegistry;
import org.apache.camel.impl.health.RoutesHealthCheckRepository;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultHealthCheckRegistryTest {
    @Test
    public void testDefaultHealthCheckRegistry() {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        registry.register((Object)new MyHealthCheck("G1", "1"));
        registry.register((Object)new MyHealthCheck("G1", "1"));
        registry.register((Object)new MyHealthCheck("G1", "2"));
        registry.register((Object)new MyHealthCheck("G2", "3"));
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)3, (int)checks.size());
        for (HealthCheck check : checks) {
            HealthCheck.Result response = check.call();
            Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)response.getState());
            Assertions.assertFalse((boolean)response.getMessage().isPresent());
            Assertions.assertFalse((boolean)response.getError().isPresent());
        }
    }

    @Test
    public void testInjectCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        registry.register((Object)new MyHealthCheck("G1", "1"));
        registry.register((Object)new MyHealthCheck("G1", "2"));
        registry.register((Object)new MyHealthCheck("G2", "3"));
        context.start();
        registry.start();
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)3, (int)checks.size());
        for (HealthCheck check : checks) {
            HealthCheck.Result response = check.call();
            Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)response.getState());
            Assertions.assertFalse((boolean)response.getMessage().isPresent());
            Assertions.assertFalse((boolean)response.getError().isPresent());
            Assertions.assertSame((Object)context, (Object)((CamelContextAware)check).getCamelContext());
        }
    }

    @Test
    public void testDiscoverFromCamelRegistry() {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        context.getRegistry().bind("check1", (Object)new MyHealthCheck("G1", "1"));
        context.getRegistry().bind("check2", (Object)new MyHealthCheck("G1", "2"));
        registry.register((Object)new MyHealthCheck("G2", "3"));
        context.start();
        registry.start();
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)3, (int)checks.size());
        for (HealthCheck check : checks) {
            HealthCheck.Result response = check.call();
            Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)response.getState());
            Assertions.assertFalse((boolean)response.getMessage().isPresent());
            Assertions.assertFalse((boolean)response.getError().isPresent());
            Assertions.assertSame((Object)context, (Object)((CamelContextAware)check).getCamelContext());
        }
    }

    @Test
    public void testResolveContextHealthCheck() {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        HealthCheck hc = (HealthCheck)registry.resolveById("context");
        Assertions.assertNotNull((Object)hc);
        Assertions.assertEquals((Object)"camel", (Object)hc.getGroup());
        Assertions.assertEquals((Object)"context", (Object)hc.getId());
        Assertions.assertInstanceOf(ContextHealthCheck.class, (Object)hc);
        registry.register((Object)hc);
        registry.register((Object)new MyHealthCheck("G1", "1"));
        registry.register((Object)new MyHealthCheck("G1", "2"));
        registry.register((Object)new MyHealthCheck("G2", "3"));
        context.start();
        registry.start();
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)4, (int)checks.size());
        for (HealthCheck check : checks) {
            HealthCheck.Result response = check.call();
            Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)response.getState());
            Assertions.assertFalse((boolean)response.getMessage().isPresent());
            Assertions.assertFalse((boolean)response.getError().isPresent());
            Assertions.assertSame((Object)context, (Object)((CamelContextAware)check).getCamelContext());
        }
    }

    @Test
    public void testResolveRoutesHealthCheck() throws Exception {
        HealthCheck.Result response;
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultHealthCheckRegistry registry = new DefaultHealthCheckRegistry();
        registry.setCamelContext((CamelContext)context);
        HealthCheckRepository hc = (HealthCheckRepository)registry.resolveById("routes");
        Assertions.assertNotNull((Object)hc);
        Assertions.assertEquals((Object)"routes", (Object)hc.getId());
        Assertions.assertInstanceOf(RoutesHealthCheckRepository.class, (Object)hc);
        registry.register((Object)hc);
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).routeId("foo");
                ((RouteDefinition)this.from("direct:start2").to("mock:bar")).routeId("bar");
            }
        });
        context.start();
        registry.start();
        List checks = registry.stream().toList();
        Assertions.assertEquals((int)2, (int)checks.size());
        for (HealthCheck check : checks) {
            response = check.call();
            Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)response.getState());
            Assertions.assertFalse((boolean)response.getMessage().isPresent());
            Assertions.assertFalse((boolean)response.getError().isPresent());
        }
        context.getRouteController().stopRoute("foo");
        for (HealthCheck check : checks) {
            response = check.call();
            boolean foo = "foo".equals(response.getDetails().get("route.id"));
            if (foo) {
                Assertions.assertEquals((Object)HealthCheck.State.DOWN, (Object)response.getState());
                Assertions.assertTrue((boolean)response.getMessage().isPresent());
                Assertions.assertFalse((boolean)response.getError().isPresent());
                continue;
            }
            Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)response.getState());
            Assertions.assertFalse((boolean)response.getMessage().isPresent());
            Assertions.assertFalse((boolean)response.getError().isPresent());
        }
    }

    private static class MyHealthCheck
    extends AbstractHealthCheck
    implements CamelContextAware {
        protected MyHealthCheck(String group, String id) {
            super(group, id);
        }

        public void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            builder.up();
        }
    }
}

