/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.health.ContextHealthCheck;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextHealthCheckTest {
    @Test
    public void testOverallStatusOnceTheContextIsStarted() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        ContextHealthCheck check = new ContextHealthCheck();
        check.setCamelContext((CamelContext)context);
        HealthCheck.Result result = check.call();
        Assertions.assertEquals((Object)HealthCheck.State.UP, (Object)result.getState());
        Assertions.assertFalse((boolean)result.getMessage().isPresent());
        Assertions.assertFalse((boolean)result.getDetails().containsKey("check.enabled"));
        Assertions.assertEquals((Object)ServiceStatus.Started, result.getDetails().get("context.status"));
    }

    @Test
    public void testOverallStatusOnceTheContextIsSuspended() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.suspend();
        ContextHealthCheck check = new ContextHealthCheck();
        check.setCamelContext((CamelContext)context);
        HealthCheck.Result result = check.call();
        Assertions.assertEquals((Object)HealthCheck.State.DOWN, (Object)result.getState());
        Assertions.assertTrue((boolean)result.getMessage().isPresent());
        Assertions.assertFalse((boolean)result.getDetails().containsKey("check.enabled"));
        Assertions.assertEquals((Object)ServiceStatus.Suspended, result.getDetails().get("context.status"));
    }
}

