/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.CamelContextRoutesStartedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppingEvent;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.impl.event.CamelContextStartingEvent;
import org.apache.camel.impl.event.CamelContextStoppedEvent;
import org.apache.camel.impl.event.CamelContextStoppingEvent;
import org.apache.camel.impl.event.ExchangeCompletedEvent;
import org.apache.camel.impl.event.ExchangeCreatedEvent;
import org.apache.camel.impl.event.ExchangeFailedEvent;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.impl.event.RouteAddedEvent;
import org.apache.camel.impl.event.RouteRemovedEvent;
import org.apache.camel.impl.event.RouteStartedEvent;
import org.apache.camel.impl.event.RouteStartingEvent;
import org.apache.camel.impl.event.RouteStoppedEvent;
import org.apache.camel.impl.event.RouteStoppingEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MultipleEventNotifierEventsTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();
    private final List<CamelEvent> events2 = new ArrayList<CamelEvent>();

    @Override
    protected boolean useJmx() {
        return true;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                MultipleEventNotifierEventsTest.this.events.add(event);
            }
        });
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                MultipleEventNotifierEventsTest.this.events2.add(event);
            }

            protected void doBuild() {
                this.setIgnoreCamelContextEvents(true);
                this.setIgnoreServiceEvents(true);
                this.setIgnoreRouteEvents(true);
            }
        });
        return context;
    }

    @Test
    public void testExchangeDone() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)20, (int)this.events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(5));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(6));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(7));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(8));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(9));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(10));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(11));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(12));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(13));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(14));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(15));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(16));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(17));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events.get(18));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(19));
        Assertions.assertEquals((int)8, (int)this.events2.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events2.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events2.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events2.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events2.get(3));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events2.get(4));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events2.get(5));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events2.get(6));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events2.get(7));
        this.context.stop();
        Assertions.assertEquals((int)30, (int)this.events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppingEvent.class, this.events.get(20));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStoppingEvent.class, this.events.get(21));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(22));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(23));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(24));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(25));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(26));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(27));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStoppedEvent.class, this.events.get(28));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppedEvent.class, this.events.get(29));
        Assertions.assertEquals((int)8, (int)this.events2.size());
    }

    @Test
    public void testExchangeFailed() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"Hello World"), (String)"Should have thrown an exception");
        MultipleEventNotifierEventsTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((int)16, (int)this.events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(5));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(6));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(7));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(8));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(9));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(10));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(11));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(12));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(13));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeFailedEvent.class, this.events.get(14));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(15));
        Assertions.assertEquals((int)4, (int)this.events2.size());
        this.context.stop();
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events2.get(0));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events2.get(1));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeFailedEvent.class, this.events2.get(2));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events2.get(3));
        Assertions.assertEquals((int)26, (int)this.events.size());
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppingEvent.class, this.events.get(16));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStoppingEvent.class, this.events.get(17));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(18));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(19));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(20));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(21));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(22));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(23));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextRoutesStoppedEvent.class, this.events.get(24));
        MultipleEventNotifierEventsTest.assertIsInstanceOf(CamelContextStoppedEvent.class, this.events.get(25));
        Assertions.assertEquals((int)4, (int)this.events2.size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

