/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Service;
import org.apache.camel.impl.event.CamelContextRoutesStartedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppingEvent;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.impl.event.CamelContextStartingEvent;
import org.apache.camel.impl.event.CamelContextStoppedEvent;
import org.apache.camel.impl.event.CamelContextStoppingEvent;
import org.apache.camel.impl.event.ServiceStopFailureEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventNotifierServiceStoppingFailedEventTest
extends ContextTestSupport {
    private static String stopOrder;
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.init();
        context.addService((Object)new MyService("A", false));
        context.addService((Object)new MyService("B", true));
        context.addService((Object)new MyService("C", false));
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierServiceStoppingFailedEventTest.this.events.add(event);
            }
        });
        return context;
    }

    @Test
    public void testStopWithFailure() {
        stopOrder = "";
        this.context.stop();
        Assertions.assertEquals((Object)"CBA", (Object)stopOrder);
        Assertions.assertEquals((int)9, (int)this.events.size());
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(0));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(1));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(2));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(3));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStoppingEvent.class, this.events.get(4));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextRoutesStoppingEvent.class, this.events.get(5));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextRoutesStoppedEvent.class, this.events.get(6));
        ServiceStopFailureEvent event = EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(ServiceStopFailureEvent.class, this.events.get(7));
        EventNotifierServiceStoppingFailedEventTest.assertIsInstanceOf(CamelContextStoppedEvent.class, this.events.get(8));
        Assertions.assertEquals((Object)"Fail B", (Object)event.getCause().getMessage());
        Assertions.assertEquals((Object)"Service stop failure: B due to Fail B", (Object)event.toString());
    }

    private static final class MyService
    implements Service {
        private final String name;
        private final boolean fail;

        private MyService(String name, boolean fail) {
            this.name = name;
            this.fail = fail;
        }

        public void start() {
        }

        public void stop() {
            stopOrder = stopOrder + this.name;
            if (this.fail) {
                throw new IllegalArgumentException("Fail " + this.name);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

