/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.ExchangeCompletedEvent;
import org.apache.camel.impl.event.ExchangeCreatedEvent;
import org.apache.camel.impl.event.ExchangeFailureHandledEvent;
import org.apache.camel.impl.event.ExchangeFailureHandlingEvent;
import org.apache.camel.impl.event.ExchangeRedeliveryEvent;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventNotifierRedeliveryEventsTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierRedeliveryEventsTest.this.events.add(event);
            }

            protected void doBuild() {
                this.setIgnoreCamelContextEvents(true);
                this.setIgnoreRouteEvents(true);
                this.setIgnoreServiceEvents(true);
                this.setIgnoreExchangeAsyncProcessingStartedEvents(true);
            }
        });
        return context;
    }

    @Test
    public void testExchangeRedeliverySync() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(4).redeliveryDelay(0L));
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        Assertions.assertEquals((int)12, (int)this.events.size());
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(0));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(1));
        ExchangeRedeliveryEvent e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(2));
        Assertions.assertEquals((int)1, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(3));
        Assertions.assertEquals((int)2, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(4));
        Assertions.assertEquals((int)3, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(5));
        Assertions.assertEquals((int)4, (int)e.getAttempt());
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, this.events.get(6));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(7));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(8));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, this.events.get(9));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events.get(10));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(11));
    }

    @Test
    public void testExchangeRedeliveryAsync() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").maximumRedeliveries(4).asyncDelayedRedelivery().redeliveryDelay(10L));
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        Assertions.assertEquals((int)12, (int)this.events.size());
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(0));
        EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(1));
        ExchangeRedeliveryEvent e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(2));
        Assertions.assertEquals((int)1, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(3));
        Assertions.assertEquals((int)2, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(4));
        Assertions.assertEquals((int)3, (int)e.getAttempt());
        e = EventNotifierRedeliveryEventsTest.assertIsInstanceOf(ExchangeRedeliveryEvent.class, this.events.get(5));
        Assertions.assertEquals((int)4, (int)e.getAttempt());
    }
}

