/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.CamelContextRoutesStartedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppingEvent;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.impl.event.CamelContextStartingEvent;
import org.apache.camel.impl.event.CamelContextStoppedEvent;
import org.apache.camel.impl.event.CamelContextStoppingEvent;
import org.apache.camel.impl.event.RouteAddedEvent;
import org.apache.camel.impl.event.RouteRemovedEvent;
import org.apache.camel.impl.event.RouteStartedEvent;
import org.apache.camel.impl.event.RouteStartingEvent;
import org.apache.camel.impl.event.RouteStoppedEvent;
import org.apache.camel.impl.event.RouteStoppingEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EventNotifierIgnoreCamelContextInitEventsTest {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();
    private CamelContext context;

    @BeforeEach
    public void setUp() throws Exception {
        this.context = this.createCamelContext();
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        ProducerTemplate template = this.context.createProducerTemplate();
        this.context.start();
    }

    @AfterEach
    public void tearDown() {
        if (this.context != null) {
            this.context.stop();
        }
    }

    protected CamelContext createCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierIgnoreCamelContextInitEventsTest.this.events.add(event);
            }

            protected void doBuild() {
                this.setIgnoreCamelContextInitEvents(true);
            }
        });
        return context;
    }

    @Test
    public void testIgnoreInitEvents() {
        Assertions.assertEquals((int)10, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(0));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(1));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(2));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(3));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(4));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(5));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(6));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(7));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(8));
        TestSupport.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(9));
        this.context.stop();
        Assertions.assertEquals((int)20, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelContextStoppingEvent.class, this.events.get(10));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStoppingEvent.class, this.events.get(11));
        TestSupport.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(12));
        TestSupport.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(13));
        TestSupport.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(14));
        TestSupport.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(15));
        TestSupport.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(16));
        TestSupport.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(17));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStoppedEvent.class, this.events.get(18));
        TestSupport.assertIsInstanceOf(CamelContextStoppedEvent.class, this.events.get(19));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

