/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.DelegateProcessor;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.CamelContextRoutesStartedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartingEvent;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.impl.event.CamelContextStartingEvent;
import org.apache.camel.impl.event.ExchangeCompletedEvent;
import org.apache.camel.impl.event.ExchangeCreatedEvent;
import org.apache.camel.impl.event.ExchangeFailureHandledEvent;
import org.apache.camel.impl.event.ExchangeFailureHandlingEvent;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.impl.event.RouteAddedEvent;
import org.apache.camel.impl.event.RouteStartedEvent;
import org.apache.camel.impl.event.RouteStartingEvent;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.processor.SendProcessor;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventNotifierFailureHandledEventsTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierFailureHandledEventsTest.this.events.add(event);
            }

            protected void doBuild() {
                this.setIgnoreExchangeAsyncProcessingStartedEvents(true);
            }
        });
        return context;
    }

    @Test
    public void testExchangeDeadLetterChannel() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)17, (int)this.events.size());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(5));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(6));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(7));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(8));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(9));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(10));
        ExchangeFailureHandlingEvent e0 = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, this.events.get(11));
        Assertions.assertTrue((boolean)e0.isDeadLetterChannel(), (String)"should be DLC");
        Assertions.assertEquals((Object)"mock:dead", (Object)e0.getDeadLetterUri());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(12));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(13));
        ExchangeFailureHandledEvent e = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, this.events.get(14));
        Assertions.assertTrue((boolean)e.isDeadLetterChannel(), (String)"should be DLC");
        Assertions.assertTrue((boolean)e.isHandled(), (String)"should be marked as failure handled");
        Assertions.assertFalse((boolean)e.isContinued(), (String)"should not be continued");
        Processor fh = e.getFailureHandler();
        if (fh.getClass().getName().endsWith("ProcessorToReactiveProcessorBridge")) {
            fh = ((DelegateProcessor)fh).getProcessor();
        }
        SendProcessor send = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(SendProcessor.class, fh);
        Assertions.assertEquals((Object)"mock://dead", (Object)send.getDestination().getEndpointUri());
        Assertions.assertEquals((Object)"mock:dead", (Object)e.getDeadLetterUri());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events.get(15));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(16));
        ExchangeSentEvent sent = (ExchangeSentEvent)this.events.get(16);
        Assertions.assertEquals((Object)"direct://start", (Object)sent.getEndpoint().getEndpointUri());
    }

    @Test
    public void testExchangeOnException() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:dead");
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)17, (int)this.events.size());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(5));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(6));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(7));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(8));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(9));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(10));
        ExchangeFailureHandlingEvent e0 = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, this.events.get(11));
        Assertions.assertFalse((boolean)e0.isDeadLetterChannel(), (String)"should NOT be DLC");
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(12));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(13));
        ExchangeFailureHandledEvent e = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, this.events.get(14));
        Assertions.assertFalse((boolean)e.isDeadLetterChannel(), (String)"should NOT be DLC");
        Assertions.assertTrue((boolean)e.isHandled(), (String)"should be marked as failure handled");
        Assertions.assertFalse((boolean)e.isContinued(), (String)"should not be continued");
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events.get(15));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(16));
        ExchangeSentEvent sent = (ExchangeSentEvent)this.events.get(16);
        Assertions.assertEquals((Object)"direct://start", (Object)sent.getEndpoint().getEndpointUri());
    }

    @Test
    public void testExchangeDoTryDoCatch() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)this.from("direct:start").doTry().throwException((Exception)new IllegalArgumentException("Damn"))).doCatch(IllegalArgumentException.class).to("mock:dead")).end();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)17, (int)this.events.size());
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(5));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(6));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(7));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(8));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(9));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(10));
        ExchangeFailureHandlingEvent e0 = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandlingEvent.class, this.events.get(11));
        Assertions.assertFalse((boolean)e0.isDeadLetterChannel(), (String)"should NOT be DLC");
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(12));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(13));
        ExchangeFailureHandledEvent e = EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeFailureHandledEvent.class, this.events.get(14));
        Assertions.assertFalse((boolean)e.isDeadLetterChannel(), (String)"should NOT be DLC");
        Assertions.assertFalse((boolean)e.isHandled(), (String)"should not be marked as failure handled as it was continued instead");
        Assertions.assertTrue((boolean)e.isContinued(), (String)"should be continued");
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events.get(15));
        EventNotifierFailureHandledEventsTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(16));
        ExchangeSentEvent sent = (ExchangeSentEvent)this.events.get(16);
        Assertions.assertEquals((Object)"direct://start", (Object)sent.getEndpoint().getEndpointUri());
    }
}

