/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EventNotifierExchangeSentTest
extends ContextTestSupport {
    protected final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @BeforeEach
    public void clearEvents() {
        this.events.clear();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierExchangeSentTest.this.events.add(event);
            }

            protected void doStart() {
                this.setIgnoreCamelContextEvents(true);
                this.setIgnoreServiceEvents(true);
                this.setIgnoreRouteEvents(true);
                this.setIgnoreExchangeCreatedEvent(true);
                this.setIgnoreExchangeCompletedEvent(true);
                this.setIgnoreExchangeFailedEvents(true);
                this.setIgnoreExchangeRedeliveryEvents(true);
                this.setIgnoreExchangeAsyncProcessingStartedEvents(true);
            }
        });
        return context;
    }

    @Test
    public void testExchangeSent() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)8, (int)this.events.size());
        ExchangeSendingEvent e0 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(0));
        ExchangeSendingEvent e1 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(1));
        ExchangeSentEvent e2 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(2));
        ExchangeSendingEvent e3 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(3));
        ExchangeSentEvent e4 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(4));
        ExchangeSendingEvent e5 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(5));
        ExchangeSentEvent e6 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(6));
        ExchangeSentEvent e7 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(7));
        Assertions.assertEquals((Object)"direct://start", (Object)e0.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"log://foo", (Object)e1.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"log://foo", (Object)e2.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)e3.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)e4.getEndpoint().getEndpointUri());
        long time = e4.getTimeTaken();
        Assertions.assertTrue((time > 400L ? 1 : 0) != 0, (String)("Should take about 0.5 sec, was: " + time));
        Assertions.assertEquals((Object)"mock://result", (Object)e5.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"mock://result", (Object)e6.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://start", (Object)e7.getEndpoint().getEndpointUri());
        time = e7.getTimeTaken();
        Assertions.assertTrue((time > 400L ? 1 : 0) != 0, (String)("Should take about 0.5 sec, was: " + time));
    }

    @Test
    public void testExchangeSentRecipient() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"direct:cool,direct:start");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        Assertions.assertEquals((int)12, (int)this.events.size());
        ExchangeSendingEvent e0 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(0));
        ExchangeSendingEvent e1 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(1));
        ExchangeSentEvent e2 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(2));
        ExchangeSendingEvent e3 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(3));
        ExchangeSendingEvent e4 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(4));
        ExchangeSentEvent e5 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(5));
        ExchangeSendingEvent e6 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(6));
        ExchangeSentEvent e7 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(7));
        ExchangeSendingEvent e8 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(8));
        ExchangeSentEvent e9 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(9));
        ExchangeSentEvent e10 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(10));
        ExchangeSentEvent e11 = EventNotifierExchangeSentTest.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(11));
        Assertions.assertEquals((Object)"direct://foo", (Object)e0.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://cool", (Object)e1.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://cool", (Object)e2.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://start", (Object)e3.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"log://foo", (Object)e4.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"log://foo", (Object)e5.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)e6.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)e7.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"mock://result", (Object)e8.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"mock://result", (Object)e9.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://start", (Object)e10.getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://foo", (Object)e11.getEndpoint().getEndpointUri());
    }

    @Test
    public void testExchangeWireTap() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:tap", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertEquals((int)6, (int)this.events.size()));
        boolean found = false;
        boolean found2 = false;
        for (CamelEvent event : this.events) {
            ExchangeSentEvent sent;
            String uri;
            if (event instanceof ExchangeSendingEvent) {
                ExchangeSendingEvent sending = (ExchangeSendingEvent)event;
                uri = sending.getEndpoint().getEndpointUri();
                if (!"log://foo".equals(uri)) continue;
                found = true;
                continue;
            }
            if (!(event instanceof ExchangeSentEvent) || !"log://foo".equals(uri = (sent = (ExchangeSentEvent)event).getEndpoint().getEndpointUri())) continue;
            found2 = true;
        }
        Assertions.assertTrue((boolean)found, (String)"We should find log:foo being wire tapped");
        Assertions.assertTrue((boolean)found2, (String)"We should find log:foo being wire tapped");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(500L);
                this.from("direct:foo").recipientList().header("foo");
                this.from("direct:cool").delay(1000L);
                this.from("direct:tap").wireTap("log:foo").to("mock:result");
            }
        };
    }
}

