/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.event.EventNotifierExchangeSentTest;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventNotifierExchangeSentParallelTest
extends EventNotifierExchangeSentTest {
    @Override
    @Test
    public void testExchangeSentRecipient() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:foo", (Object)"Hello World", "foo", (Object)"direct:cool,direct:start");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.oneExchangeDone.matchesWaitTime());
        this.context.stop();
        Assertions.assertTrue((this.events.size() >= 11 ? 1 : 0) != 0, (String)("Should be 11 or more, was: " + this.events.size()));
        int sent = 0;
        int sending = 0;
        for (CamelEvent event : this.events) {
            if (event instanceof ExchangeSendingEvent) {
                ++sending;
                continue;
            }
            ++sent;
        }
        Assertions.assertTrue((sending >= 5 ? 1 : 0) != 0, (String)("There should be 5 or more, was " + sending));
        Assertions.assertTrue((sent >= 5 ? 1 : 0) != 0, (String)("There should be 5 or more, was " + sent));
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(500L);
                this.from("direct:foo").recipientList((Expression)this.header("foo")).parallelProcessing();
                this.from("direct:cool").delay(1000L);
                this.from("direct:tap").wireTap("log:foo").to("mock:result");
            }
        };
    }
}

