/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.ExchangeCompletedEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventNotifierExchangeCompletedTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierExchangeCompletedTest.this.events.add(event);
            }

            public boolean isEnabled(CamelEvent event) {
                return event instanceof ExchangeCompletedEvent;
            }
        });
        return context;
    }

    @Test
    public void testExchangeCompleted() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.events.size());
        ExchangeCompletedEvent event = (ExchangeCompletedEvent)this.events.get(0);
        Assertions.assertNotNull((Object)event.getExchange());
        Assertions.assertNotNull((Object)event.getExchange().getFromEndpoint());
        Assertions.assertEquals((Object)"direct://start", (Object)event.getExchange().getFromEndpoint().getEndpointUri());
        long created = event.getExchange().getClock().getCreated();
        Assertions.assertTrue((created > 0L ? 1 : 0) != 0);
        Date now = new Date();
        long elapsed = now.getTime() - created;
        Assertions.assertTrue((elapsed > 400L ? 1 : 0) != 0, (String)("Should be > 400, was: " + elapsed));
        this.log.info("Elapsed time in millis: {}", (Object)elapsed);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(500L).to("mock:bar");
            }
        };
    }
}

