/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.event.CamelContextResumedEvent;
import org.apache.camel.impl.event.CamelContextResumingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStartingEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppedEvent;
import org.apache.camel.impl.event.CamelContextRoutesStoppingEvent;
import org.apache.camel.impl.event.CamelContextStartedEvent;
import org.apache.camel.impl.event.CamelContextStartingEvent;
import org.apache.camel.impl.event.CamelContextStoppedEvent;
import org.apache.camel.impl.event.CamelContextStoppingEvent;
import org.apache.camel.impl.event.CamelContextSuspendedEvent;
import org.apache.camel.impl.event.CamelContextSuspendingEvent;
import org.apache.camel.impl.event.ExchangeCompletedEvent;
import org.apache.camel.impl.event.ExchangeCreatedEvent;
import org.apache.camel.impl.event.ExchangeFailedEvent;
import org.apache.camel.impl.event.ExchangeSendingEvent;
import org.apache.camel.impl.event.ExchangeSentEvent;
import org.apache.camel.impl.event.RouteAddedEvent;
import org.apache.camel.impl.event.RouteRemovedEvent;
import org.apache.camel.impl.event.RouteStartedEvent;
import org.apache.camel.impl.event.RouteStartingEvent;
import org.apache.camel.impl.event.RouteStoppedEvent;
import org.apache.camel.impl.event.RouteStoppingEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EventNotifierEventsTest {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();
    private CamelContext context;
    private ProducerTemplate template;

    @BeforeEach
    public void setUp() throws Exception {
        this.context = this.createCamelContext();
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.template = this.context.createProducerTemplate();
        this.context.start();
    }

    @AfterEach
    public void tearDown() {
        if (this.context != null) {
            this.context.stop();
        }
    }

    protected CamelContext createCamelContext() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                EventNotifierEventsTest.this.events.add(event);
            }
        });
        return context;
    }

    @Test
    public void testExchangeDone() throws Exception {
        Assertions.assertTrue((boolean)this.context.getCamelContextExtension().isEventNotificationApplicable());
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        mock.assertIsSatisfied();
        Assertions.assertEquals((int)20, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        TestSupport.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        TestSupport.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(5));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(6));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(7));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(8));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(9));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(10));
        TestSupport.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(11));
        TestSupport.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(13));
        TestSupport.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(14));
        TestSupport.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(15));
        TestSupport.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(16));
        TestSupport.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(17));
        TestSupport.assertIsInstanceOf(ExchangeCompletedEvent.class, this.events.get(18));
        TestSupport.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(19));
        this.context.stop();
        Assertions.assertEquals((int)30, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelContextStoppingEvent.class, this.events.get(20));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStoppingEvent.class, this.events.get(21));
        TestSupport.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(22));
        TestSupport.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(23));
        TestSupport.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(24));
        TestSupport.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(25));
        TestSupport.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(26));
        TestSupport.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(27));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStoppedEvent.class, this.events.get(28));
        TestSupport.assertIsInstanceOf(CamelContextStoppedEvent.class, this.events.get(29));
    }

    @Test
    public void testExchangeFailed() {
        Assertions.assertTrue((boolean)this.context.getCamelContextExtension().isEventNotificationApplicable());
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:fail", (Object)"Hello World"), (String)"Should have thrown an exception");
        TestSupport.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((int)16, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        TestSupport.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        TestSupport.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(5));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(6));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(7));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(8));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(9));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(10));
        TestSupport.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(11));
        TestSupport.assertIsInstanceOf(ExchangeSendingEvent.class, this.events.get(12));
        TestSupport.assertIsInstanceOf(ExchangeCreatedEvent.class, this.events.get(13));
        TestSupport.assertIsInstanceOf(ExchangeFailedEvent.class, this.events.get(14));
        TestSupport.assertIsInstanceOf(ExchangeSentEvent.class, this.events.get(15));
        this.context.stop();
        Assertions.assertEquals((int)26, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelContextStoppingEvent.class, this.events.get(16));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStoppingEvent.class, this.events.get(17));
        TestSupport.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(18));
        TestSupport.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(19));
        TestSupport.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(20));
        TestSupport.assertIsInstanceOf(RouteStoppingEvent.class, this.events.get(21));
        TestSupport.assertIsInstanceOf(RouteStoppedEvent.class, this.events.get(22));
        TestSupport.assertIsInstanceOf(RouteRemovedEvent.class, this.events.get(23));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStoppedEvent.class, this.events.get(24));
        TestSupport.assertIsInstanceOf(CamelContextStoppedEvent.class, this.events.get(25));
    }

    @Test
    public void testSuspendResume() {
        Assertions.assertTrue((boolean)this.context.getCamelContextExtension().isEventNotificationApplicable());
        Assertions.assertEquals((int)12, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelEvent.CamelContextInitializingEvent.class, this.events.get(0));
        TestSupport.assertIsInstanceOf(CamelEvent.CamelContextInitializedEvent.class, this.events.get(1));
        TestSupport.assertIsInstanceOf(CamelContextStartingEvent.class, this.events.get(2));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartingEvent.class, this.events.get(3));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(4));
        TestSupport.assertIsInstanceOf(RouteAddedEvent.class, this.events.get(5));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(6));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(7));
        TestSupport.assertIsInstanceOf(RouteStartingEvent.class, this.events.get(8));
        TestSupport.assertIsInstanceOf(RouteStartedEvent.class, this.events.get(9));
        TestSupport.assertIsInstanceOf(CamelContextRoutesStartedEvent.class, this.events.get(10));
        TestSupport.assertIsInstanceOf(CamelContextStartedEvent.class, this.events.get(11));
        this.context.suspend();
        Assertions.assertEquals((int)14, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelContextSuspendingEvent.class, this.events.get(12));
        TestSupport.assertIsInstanceOf(CamelContextSuspendedEvent.class, this.events.get(13));
        this.context.resume();
        Assertions.assertEquals((int)16, (int)this.events.size());
        TestSupport.assertIsInstanceOf(CamelContextResumingEvent.class, this.events.get(14));
        TestSupport.assertIsInstanceOf(CamelContextResumedEvent.class, this.events.get(15));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
                this.from("direct:fail").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

