/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelEventsTimestampEnabledTest
extends ContextTestSupport {
    private final List<CamelEvent> events = new ArrayList<CamelEvent>();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(this.createCamelRegistry());
        context.getManagementStrategy().getEventFactory().setTimestampEnabled(true);
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(CamelEvent event) {
                CamelEventsTimestampEnabledTest.this.events.add(event);
            }

            protected void doBuild() {
                this.setIgnoreExchangeEvents(true);
                this.setIgnoreRouteEvents(true);
            }
        });
        return context;
    }

    @Test
    public void testTimestamp() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertEquals((int)10, (int)this.events.size());
        this.events.forEach(e -> Assertions.assertTrue((e.getTimestamp() > 0L ? 1 : 0) != 0, (String)"should include timestamp"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

