/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VetoCamelContextStartExceptionTest {
    @Test
    public void testVetoOnStarting() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextStarting(CamelContext context) throws VetoCamelContextStartException {
                throw new VetoCamelContextStartException("Veto on starting", context, true);
            }
        });
        Throwable throwable = Assertions.assertThrows(Throwable.class, () -> ((CamelContext)context).start());
        Assertions.assertTrue((boolean)context.isVetoStarted());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
        Assertions.assertEquals((Object)"org.apache.camel.VetoCamelContextStartException: Veto on starting", (Object)throwable.getMessage());
    }

    @Test
    public void testVetoOnStartingWithoutRethrow() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextStarting(CamelContext context) throws VetoCamelContextStartException {
                throw new VetoCamelContextStartException("Veto on starting", context, false);
            }
        });
        context.start();
        Assertions.assertTrue((boolean)context.isVetoStarted());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
    }

    @Test
    public void testVetoOnInitializing() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextInitializing(CamelContext context) throws VetoCamelContextStartException {
                throw new VetoCamelContextStartException("Veto on initializing", context, true);
            }
        });
        Throwable throwable = Assertions.assertThrows(Throwable.class, () -> ((CamelContext)context).start());
        Assertions.assertTrue((boolean)context.isVetoStarted());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
        Assertions.assertEquals((Object)"org.apache.camel.VetoCamelContextStartException: Veto on initializing", (Object)throwable.getMessage());
    }

    @Test
    public void testVetoOnInitializingWithoutRethrow() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextInitializing(CamelContext context) throws VetoCamelContextStartException {
                throw new VetoCamelContextStartException("Veto on initializing", context, false);
            }
        });
        context.start();
        Assertions.assertTrue((boolean)context.isVetoStarted());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
    }

    @Test
    public void testVetoOnInitialized() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
                throw new VetoCamelContextStartException("Veto on initialized", context, true);
            }
        });
        Throwable throwable = Assertions.assertThrows(Throwable.class, () -> ((CamelContext)context).start());
        Assertions.assertTrue((boolean)context.isVetoStarted());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
        Assertions.assertEquals((Object)"org.apache.camel.VetoCamelContextStartException: Veto on initialized", (Object)throwable.getMessage());
    }

    @Test
    public void testVetoOnInitializedWithoutRethrow() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
                throw new VetoCamelContextStartException("Veto on initialized", context, false);
            }
        });
        context.start();
        Assertions.assertTrue((boolean)context.isVetoStarted());
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
    }

    @Test
    public void testVetoReset() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            final boolean[] needThrowVeto = new boolean[]{true};
            context.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

                public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
                    if (needThrowVeto[0]) {
                        needThrowVeto[0] = false;
                        throw new VetoCamelContextStartException("Veto on initialized", context, false);
                    }
                }
            });
            context.start();
            Assertions.assertTrue((boolean)context.isVetoStarted());
            Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)context.getStatus());
            context.start();
            Assertions.assertFalse((boolean)context.isVetoStarted());
            Assertions.assertEquals((Object)ServiceStatus.Started, (Object)context.getStatus());
        }
    }
}

