/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteRemove2Test
extends ContextTestSupport {
    @Test
    public void testRemove() throws Exception {
        DefaultCamelContext defaultContext = (DefaultCamelContext)this.context;
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)2, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)2, (int)defaultContext.getCamelContextExtension().getRouteStartupOrder().size());
        Assertions.assertEquals((int)2, (int)defaultContext.getRouteServices().size());
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("bar").name());
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("bar").name());
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        boolean removed = this.context.removeRoute("foo");
        Assertions.assertTrue((boolean)removed, (String)"Route should be removed");
        Assertions.assertNull((Object)this.context.getRouteController().getRouteStatus("foo"), (String)"There should be no foo route anymore");
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("bar").name());
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("seda:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.context.getRoutes().size());
        Assertions.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        Assertions.assertEquals((int)1, (int)defaultContext.getCamelContextExtension().getRouteStartupOrder().size());
        Assertions.assertEquals((int)1, (int)defaultContext.getRouteServices().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("seda:bar")).to("mock:foo");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }
}

