/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.support.service.ServiceSupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PeriodTaskSchedulerTest
extends ContextTestSupport {
    private final AtomicInteger counter = new AtomicInteger();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testScheduler() {
        this.counter.set(0);
        PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)this.context);
        if (scheduler instanceof TimerListenerManager) {
            TimerListenerManager timerListenerManager = (TimerListenerManager)scheduler;
            timerListenerManager.setInterval(10L);
        }
        scheduler.schedulePeriodTask(this.counter::incrementAndGet, 10L);
        this.context.start();
        Awaitility.waitAtMost((long)5L, (TimeUnit)TimeUnit.SECONDS).until(() -> this.counter.get() > 0);
    }

    @Test
    public void testSchedulerLifecycle() {
        this.counter.set(0);
        MyTask task = new MyTask();
        PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)this.context);
        if (scheduler instanceof TimerListenerManager) {
            TimerListenerManager timerListenerManager = (TimerListenerManager)scheduler;
            timerListenerManager.setInterval(10L);
        }
        scheduler.schedulePeriodTask((Runnable)task, 10L);
        this.context.start();
        Awaitility.waitAtMost((long)5L, (TimeUnit)TimeUnit.SECONDS).until(() -> this.counter.get() > 1);
        Assertions.assertTrue((boolean)task.getEvent().startsWith("start"));
        Assertions.assertTrue((boolean)task.getEvent().endsWith("run"));
        this.context.stop();
        Assertions.assertTrue((boolean)task.getEvent().endsWith("stop"));
    }

    @Test
    public void testSchedulerRun() {
        AtomicInteger taskCounter = new AtomicInteger();
        this.counter.set(0);
        PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)this.context);
        if (scheduler instanceof TimerListenerManager) {
            TimerListenerManager timerListenerManager = (TimerListenerManager)scheduler;
            timerListenerManager.setInterval(10L);
        }
        scheduler.scheduledTask(() -> {
            this.counter.incrementAndGet();
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                taskCounter.incrementAndGet();
            }
        });
        this.context.start();
        Awaitility.waitAtMost((long)5L, (TimeUnit)TimeUnit.SECONDS).until(() -> this.counter.get() == 1 && taskCounter.get() == 10);
    }

    private class MyTask
    extends ServiceSupport
    implements Runnable {
        private volatile String event = "";

        private MyTask() {
        }

        public String getEvent() {
            return this.event;
        }

        protected void doStart() {
            this.event = this.event + "start";
        }

        protected void doStop() {
            this.event = this.event + "stop";
        }

        @Override
        public void run() {
            PeriodTaskSchedulerTest.this.counter.incrementAndGet();
            this.event = this.event + "run";
        }
    }
}

