/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.engine.IntrospectionSupport;
import org.apache.camel.support.jndi.ExampleBean;
import org.apache.camel.util.AnotherExampleBean;
import org.apache.camel.util.OtherExampleBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IntrospectionSupportTest
extends ContextTestSupport {
    @Test
    public void testOverloadSetterChooseStringSetter() throws Exception {
        MyOverloadedBean overloadedBean = new MyOverloadedBean();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)overloadedBean, (String)"bean", (Object)"James");
        Assertions.assertEquals((Object)"James", (Object)overloadedBean.getName());
    }

    @Test
    public void testOverloadSetterChooseBeanSetter() throws Exception {
        MyOverloadedBean overloadedBean = new MyOverloadedBean();
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)overloadedBean, (String)"bean", (Object)bean);
        Assertions.assertEquals((Object)"Claus", (Object)overloadedBean.getName());
    }

    @Test
    public void testOverloadSetterChooseUsingTypeConverter() throws Exception {
        MyOverloadedBean overloadedBean = new MyOverloadedBean();
        byte[] value = "Willem".getBytes();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)overloadedBean, (String)"bean", (Object)value);
        Assertions.assertEquals((Object)"Willem", (Object)overloadedBean.getName());
    }

    @Test
    public void testPassword() throws Exception {
        MyPasswordBean passwordBean = new MyPasswordBean();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)passwordBean, (String)"oldPassword", (Object)"Donald");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)passwordBean, (String)"newPassword", (Object)"Duck");
        Assertions.assertEquals((Object)"Donald", (Object)passwordBean.getOldPassword());
        Assertions.assertEquals((Object)"Duck", (Object)passwordBean.getNewPassword());
    }

    @Test
    public void testBuilderPatternWith() throws Exception {
        MyBuilderPatternWithBean builderBean = new MyBuilderPatternWithBean();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)builderBean, (String)"name", (Object)"Donald");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)builderBean, (String)"age", (Object)"33");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)builderBean, (String)"gold-customer", (Object)"true");
        Assertions.assertEquals((Object)"Donald", (Object)builderBean.getName());
        Assertions.assertEquals((int)33, (int)builderBean.getAge());
        Assertions.assertTrue((boolean)builderBean.isGoldCustomer());
    }

    @Test
    public void testBuilderPattern() throws Exception {
        MyBuilderPatternBean builderBean = new MyBuilderPatternBean();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)builderBean, (String)"name", (Object)"Goofy");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)builderBean, (String)"age", (Object)"34");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)builderBean, (String)"gold-customer", (Object)"true");
        Assertions.assertEquals((Object)"Goofy", (Object)builderBean.getName());
        Assertions.assertEquals((int)34, (int)builderBean.getAge());
        Assertions.assertTrue((boolean)builderBean.isGoldCustomer());
    }

    @Test
    public void testIsSetterBuilderPatternSupport() throws Exception {
        Method setter = MyBuilderBean.class.getMethod("setName", String.class);
        Method setter2 = MyOtherBuilderBean.class.getMethod("setName", String.class);
        Method setter3 = MyOtherOtherBuilderBean.class.getMethod("setName", String.class);
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setter, (boolean)false));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)setter, (boolean)true));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setter2, (boolean)false));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)setter2, (boolean)true));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setter3, (boolean)false));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)setter3, (boolean)true));
    }

    @Test
    public void testGetProperties() {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, null);
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"Claus", map.get("name"));
        String price = map.get("price").toString();
        Assertions.assertTrue((boolean)price.startsWith("10"));
        Assertions.assertNull(map.get("id"));
    }

    @Test
    public void testAnotherGetProperties() {
        AnotherExampleBean bean = new AnotherExampleBean();
        bean.setId("123");
        bean.setName("Claus");
        bean.setPrice(10.0);
        Date date = new Date(0L);
        bean.setDate(date);
        bean.setGoldCustomer(true);
        bean.setLittle(true);
        ArrayList children = new ArrayList();
        bean.setChildren(children);
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, null);
        Assertions.assertEquals((int)7, (int)map.size());
        Assertions.assertEquals((Object)"Claus", map.get("name"));
        String price = map.get("price").toString();
        Assertions.assertTrue((boolean)price.startsWith("10"));
        Assertions.assertSame((Object)date, map.get("date"));
        Assertions.assertSame(children, map.get("children"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("goldCustomer"));
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("little"));
        Assertions.assertEquals((Object)"123", map.get("id"));
    }

    @Test
    public void testGetPropertiesOptionPrefix() {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        bean.setId("123");
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, (String)"bean.");
        Assertions.assertEquals((int)3, (int)map.size());
        Assertions.assertEquals((Object)"Claus", map.get("bean.name"));
        String price = map.get("bean.price").toString();
        Assertions.assertTrue((boolean)price.startsWith("10"));
        Assertions.assertEquals((Object)"123", map.get("bean.id"));
    }

    @Test
    public void testGetPropertiesSkipNull() {
        ExampleBean bean = new ExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        bean.setId(null);
        HashMap map = new HashMap();
        IntrospectionSupport.getProperties((Object)bean, map, null, (boolean)false);
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((Object)"Claus", map.get("name"));
        String price = map.get("price").toString();
        Assertions.assertTrue((boolean)price.startsWith("10"));
    }

    @Test
    public void testGetProperty() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setId("123");
        bean.setName("Claus");
        bean.setPrice(10.0);
        Object name = IntrospectionSupport.getProperty((Object)bean, (String)"name");
        Assertions.assertEquals((Object)"Claus", (Object)name);
    }

    @Test
    public void testSetProperty() throws Exception {
        ExampleBean bean = new ExampleBean();
        bean.setId("123");
        bean.setName("Claus");
        bean.setPrice(10.0);
        IntrospectionSupport.setProperty((CamelContext)this.context, (Object)bean, (String)"name", (Object)"James");
        Assertions.assertEquals((Object)"James", (Object)bean.getName());
    }

    @Test
    public void testSetPropertyDash() throws Exception {
        AnotherExampleBean bean = new AnotherExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        Date date = new Date(0L);
        bean.setDate(date);
        bean.setGoldCustomer(true);
        bean.setLittle(true);
        IntrospectionSupport.setProperty((CamelContext)this.context, (Object)bean, (String)"name", (Object)"James");
        IntrospectionSupport.setProperty((CamelContext)this.context, (Object)bean, (String)"gold-customer", (Object)"false");
        Assertions.assertEquals((Object)"James", (Object)bean.getName());
        Assertions.assertEquals((Object)false, (Object)bean.isGoldCustomer());
    }

    @Test
    public void testAnotherGetProperty() throws Exception {
        AnotherExampleBean bean = new AnotherExampleBean();
        bean.setName("Claus");
        bean.setPrice(10.0);
        Date date = new Date(0L);
        bean.setDate(date);
        bean.setGoldCustomer(true);
        bean.setLittle(true);
        ArrayList children = new ArrayList();
        bean.setChildren(children);
        Object name = IntrospectionSupport.getProperty((Object)bean, (String)"name");
        Assertions.assertEquals((Object)"Claus", (Object)name);
        Assertions.assertSame((Object)date, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"date"));
        Assertions.assertSame(children, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"children"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"goldCustomer"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"gold-customer"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)IntrospectionSupport.getProperty((Object)bean, (String)"little"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPropertyLocaleIndependent() throws Exception {
        Locale oldLocale = Locale.getDefault();
        Locale.setDefault(new Locale("tr", "TR"));
        try {
            ExampleBean bean = new ExampleBean();
            bean.setName("Claus");
            bean.setPrice(10.0);
            bean.setId("1");
            Object name = IntrospectionSupport.getProperty((Object)bean, (String)"name");
            Object id = IntrospectionSupport.getProperty((Object)bean, (String)"id");
            Object price = IntrospectionSupport.getProperty((Object)bean, (String)"price");
            Assertions.assertEquals((Object)"Claus", (Object)name);
            Assertions.assertEquals((Object)10.0, (Object)price);
            Assertions.assertEquals((Object)"1", (Object)id);
        }
        finally {
            Locale.setDefault(oldLocale);
        }
    }

    @Test
    public void testGetPropertyGetter() throws Exception {
        Method name = IntrospectionSupport.getPropertyGetter(ExampleBean.class, (String)"name");
        Assertions.assertEquals((Object)"getName", (Object)name.getName());
        NoSuchMethodException e = (NoSuchMethodException)Assertions.assertThrows(NoSuchMethodException.class, () -> IntrospectionSupport.getPropertyGetter(ExampleBean.class, (String)"xxx"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"org.apache.camel.support.jndi.ExampleBean.getXxx()", (Object)e.getMessage());
    }

    @Test
    public void testGetPropertySetter() throws Exception {
        Method name = IntrospectionSupport.getPropertySetter(ExampleBean.class, (String)"name");
        Assertions.assertEquals((Object)"setName", (Object)name.getName());
        NoSuchMethodException e = (NoSuchMethodException)Assertions.assertThrows(NoSuchMethodException.class, () -> IntrospectionSupport.getPropertySetter(ExampleBean.class, (String)"xxx"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"org.apache.camel.support.jndi.ExampleBean.setXxx", (Object)e.getMessage());
    }

    @Test
    public void testIsGetter() throws Exception {
        ExampleBean bean = new ExampleBean();
        Method name = bean.getClass().getMethod("getName", null);
        Assertions.assertTrue((boolean)IntrospectionSupport.isGetter((Method)name));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)name));
        Method price = bean.getClass().getMethod("getPrice", null);
        Assertions.assertTrue((boolean)IntrospectionSupport.isGetter((Method)price));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)price));
    }

    @Test
    public void testIsSetter() throws Exception {
        ExampleBean bean = new ExampleBean();
        Method name = bean.getClass().getMethod("setName", String.class);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)name));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)name));
        Method price = bean.getClass().getMethod("setPrice", Double.TYPE);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)price));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)price));
    }

    @Test
    public void testOtherIsGetter() throws Exception {
        OtherExampleBean bean = new OtherExampleBean();
        Method customerId = bean.getClass().getMethod("getCustomerId", null);
        Assertions.assertTrue((boolean)IntrospectionSupport.isGetter((Method)customerId));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)customerId));
        Method goldCustomer = bean.getClass().getMethod("isGoldCustomer", null);
        Assertions.assertTrue((boolean)IntrospectionSupport.isGetter((Method)goldCustomer));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)goldCustomer));
        Method silverCustomer = bean.getClass().getMethod("isSilverCustomer", null);
        Assertions.assertTrue((boolean)IntrospectionSupport.isGetter((Method)silverCustomer));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)silverCustomer));
        Method company = bean.getClass().getMethod("getCompany", null);
        Assertions.assertTrue((boolean)IntrospectionSupport.isGetter((Method)company));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)company));
        Method setupSomething = bean.getClass().getMethod("setupSomething", Object.class);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)setupSomething));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setupSomething));
    }

    @Test
    public void testOtherIsSetter() throws Exception {
        OtherExampleBean bean = new OtherExampleBean();
        Method customerId = bean.getClass().getMethod("setCustomerId", Integer.TYPE);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)customerId));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)customerId));
        Method goldCustomer = bean.getClass().getMethod("setGoldCustomer", Boolean.TYPE);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)goldCustomer));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)goldCustomer));
        Method silverCustomer = bean.getClass().getMethod("setSilverCustomer", Boolean.class);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)silverCustomer));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)silverCustomer));
        Method company = bean.getClass().getMethod("setCompany", String.class);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)company));
        Assertions.assertTrue((boolean)IntrospectionSupport.isSetter((Method)company));
        Method setupSomething = bean.getClass().getMethod("setupSomething", Object.class);
        Assertions.assertFalse((boolean)IntrospectionSupport.isGetter((Method)setupSomething));
        Assertions.assertFalse((boolean)IntrospectionSupport.isSetter((Method)setupSomething));
    }

    @Test
    public void testFindSetterMethodsOrderedByParameterType() {
        List setters = IntrospectionSupport.findSetterMethodsOrderedByParameterType(MyOverloadedBean.class, (String)"bean", (boolean)false, (boolean)false, (boolean)false);
        Assertions.assertNotNull((Object)setters);
        Assertions.assertEquals((int)2, (int)setters.size());
        Assertions.assertEquals(ExampleBean.class, ((Method)setters.get(0)).getParameterTypes()[0]);
        Assertions.assertEquals(String.class, ((Method)setters.get(1)).getParameterTypes()[0]);
    }

    @Test
    public void testArray() throws Exception {
        MyBeanWithArray target = new MyBeanWithArray();
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)target, (String)"names[0]", (Object)"James");
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)target, (String)"names[1]", (Object)"Claus");
        Assertions.assertEquals((Object)"James", (Object)target.getNames()[0]);
        Assertions.assertEquals((Object)"Claus", (Object)target.getNames()[1]);
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)target, (String)"names[0]", (Object)"JamesX");
        Assertions.assertEquals((Object)"JamesX", (Object)target.getNames()[0]);
        IntrospectionSupport.setProperty((TypeConverter)this.context.getTypeConverter(), (Object)target, (String)"names[2]", (Object)"Andrea");
        Assertions.assertEquals((Object)"JamesX", (Object)target.getNames()[0]);
        Assertions.assertEquals((Object)"Claus", (Object)target.getNames()[1]);
        Assertions.assertEquals((Object)"Andrea", (Object)target.getNames()[2]);
    }

    public static class MyOverloadedBean {
        private ExampleBean bean;

        public void setBean(ExampleBean bean) {
            this.bean = bean;
        }

        public void setBean(String name) {
            this.bean = new ExampleBean();
            this.bean.setName(name);
        }

        public String getName() {
            return this.bean.getName();
        }
    }

    public static class MyPasswordBean {
        private String oldPassword;
        private String newPassword;

        public String getOldPassword() {
            return this.oldPassword;
        }

        public void setOldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }
    }

    public static class MyBuilderPatternWithBean {
        private String name;
        private int age;
        private boolean goldCustomer;

        public MyBuilderPatternWithBean withName(String name) {
            this.name = name;
            return this;
        }

        public MyBuilderPatternWithBean withAge(int age) {
            this.age = age;
            return this;
        }

        public MyBuilderPatternWithBean withGoldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }
    }

    public static class MyBuilderPatternBean {
        private String name;
        private int age;
        private boolean goldCustomer;

        public MyBuilderPatternBean name(String name) {
            this.name = name;
            return this;
        }

        public MyBuilderPatternBean age(int age) {
            this.age = age;
            return this;
        }

        public MyBuilderPatternBean goldCustomer(boolean goldCustomer) {
            this.goldCustomer = goldCustomer;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }

        public boolean isGoldCustomer() {
            return this.goldCustomer;
        }
    }

    public static class MyBuilderBean {
        private String name;

        public String getName() {
            return this.name;
        }

        public MyBuilderBean setName(String name) {
            this.name = name;
            return this;
        }
    }

    public static class MyOtherBuilderBean
    extends MyBuilderBean {
    }

    public static class MyOtherOtherBuilderBean
    extends MyOtherBuilderBean {
        @Override
        public MyOtherOtherBuilderBean setName(String name) {
            super.setName(name);
            return this;
        }
    }

    public static class MyBeanWithArray {
        private String[] names = new String[10];

        public String[] getNames() {
            return this.names;
        }

        public void setNames(String[] names) {
            this.names = names;
        }
    }
}

