/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EmptyProducerCacheTest
extends ContextTestSupport {
    @Test
    public void testEmptyCache() {
        EmptyProducerCache cache = new EmptyProducerCache((Object)this, (CamelContext)this.context);
        cache.start();
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 0");
        Endpoint e = this.context.getEndpoint("direct:queue:1");
        AsyncProducer p = cache.acquireProducer(e);
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 0");
        cache.releaseProducer(e, p);
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 0");
        cache.stop();
    }

    @Test
    public void testCacheProducerAcquireAndRelease() {
        EmptyProducerCache cache = new EmptyProducerCache((Object)this, (CamelContext)this.context);
        cache.start();
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 0");
        for (int i = 0; i < 1003; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            AsyncProducer p = cache.acquireProducer(e);
            cache.releaseProducer(e, p);
        }
        Assertions.assertEquals((int)0, (int)cache.size(), (String)"Size should be 1000");
        cache.stop();
    }
}

