/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultTransformerResolver;
import org.apache.camel.impl.engine.LowercaseDataTypeTransformer;
import org.apache.camel.processor.transformer.StringDataTypeTransformer;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DefaultTransformerResolverTest {
    private DefaultCamelContext camelContext;
    private final DefaultTransformerResolver resolver = new DefaultTransformerResolver();

    DefaultTransformerResolverTest() {
    }

    @BeforeEach
    void setup() {
        this.camelContext = new DefaultCamelContext();
    }

    @Test
    public void shouldHandleUnresolvableDataTypeTransformers() {
        Transformer transformer = this.resolver.resolve(new TransformerKey("unknown"), (CamelContext)this.camelContext);
        Assertions.assertNull((Object)transformer);
        transformer = this.resolver.resolve(new TransformerKey(new DataType("foo:fromType"), new DataType("foo:toType")), (CamelContext)this.camelContext);
        Assertions.assertNull((Object)transformer);
    }

    @Test
    public void shouldResolveDataTypeTransformers() {
        Transformer transformer = this.resolver.resolve(new TransformerKey("text-plain"), (CamelContext)this.camelContext);
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(StringDataTypeTransformer.class, transformer.getClass());
        transformer = this.resolver.resolve(new TransformerKey("lowercase"), (CamelContext)this.camelContext);
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(LowercaseDataTypeTransformer.class, transformer.getClass());
        transformer = this.resolver.resolve(new TransformerKey(new DataType("foo"), new DataType("json")), (CamelContext)this.camelContext);
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(FooDataTypeTransformer.class, transformer.getClass());
    }

    @DataTypeTransformer(name="foo-json", fromType="foo", toType="json")
    public static class FooDataTypeTransformer
    extends Transformer {
        public void transform(Message message, DataType fromType, DataType toType) {
            message.setBody((Object)"Foo");
        }
    }
}

