/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultTransformerRegistry;
import org.apache.camel.impl.engine.LowercaseDataTypeTransformer;
import org.apache.camel.impl.engine.UppercaseDataTypeTransformer;
import org.apache.camel.processor.transformer.ByteArrayDataTypeTransformer;
import org.apache.camel.processor.transformer.StringDataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultTransformerRegistryTest {
    private final DefaultTransformerRegistry dataTypeRegistry = new DefaultTransformerRegistry((CamelContext)new DefaultCamelContext());

    DefaultTransformerRegistryTest() {
    }

    @Test
    public void shouldLookupDefaultDataTypeTransformers() {
        Transformer transformer = this.dataTypeRegistry.resolveTransformer(new TransformerKey("text-plain"));
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(StringDataTypeTransformer.class, transformer.getClass());
        transformer = this.dataTypeRegistry.resolveTransformer(new TransformerKey("application-octet-stream"));
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(ByteArrayDataTypeTransformer.class, transformer.getClass());
        transformer = this.dataTypeRegistry.resolveTransformer(new TransformerKey("lowercase"));
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(LowercaseDataTypeTransformer.class, transformer.getClass());
        transformer = this.dataTypeRegistry.resolveTransformer(new TransformerKey("uppercase"));
        Assertions.assertNotNull((Object)transformer);
        Assertions.assertEquals(UppercaseDataTypeTransformer.class, transformer.getClass());
    }
}

