/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.event.RouteRestartingEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class DefaultSupervisingRouteControllerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testSupervising() throws Exception {
        this.context.addRoutes((RoutesBuilder)new MyRoute());
        SupervisingRouteController src = this.context.getRouteController().supervising();
        src.setBackOffDelay(25L);
        src.setBackOffMaxAttempts(3L);
        src.setInitialDelay(100L);
        src.setThreadPoolSize(2);
        final List<CamelEvent.RouteRestartingFailureEvent> failures = Collections.synchronizedList(new ArrayList());
        final List events = Collections.synchronizedList(new ArrayList());
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                if (event instanceof CamelEvent.RouteRestartingFailureEvent) {
                    CamelEvent.RouteRestartingFailureEvent rfe = (CamelEvent.RouteRestartingFailureEvent)event;
                    failures.add(rfe);
                } else if (event instanceof RouteRestartingEvent) {
                    RouteRestartingEvent rre = (RouteRestartingEvent)event;
                    events.add(rre);
                }
            }
        });
        this.context.start();
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:foo", MockEndpoint.class);
        mock.expectedMinimumMessageCount(3);
        MockEndpoint mock2 = (MockEndpoint)this.context.getEndpoint("mock:cheese", MockEndpoint.class);
        mock2.expectedMessageCount(0);
        MockEndpoint mock3 = (MockEndpoint)this.context.getEndpoint("mock:cake", MockEndpoint.class);
        mock3.expectedMessageCount(0);
        MockEndpoint mock4 = (MockEndpoint)this.context.getEndpoint("mock:bar", MockEndpoint.class);
        mock4.expectedMessageCount(0);
        MockEndpoint.assertIsSatisfied((long)10L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{mock, mock2, mock3, mock4});
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").toString());
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("cheese").toString());
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("cake").toString());
        Awaitility.await((String)"Await all exceptions and retries finished").atMost(Duration.ofMillis(src.getInitialDelay() + src.getBackOffDelay() * (src.getBackOffMaxAttempts() + 1L))).untilAsserted(() -> Assertions.assertNotNull((Object)src.getRestartException("cake")));
        Throwable e = src.getRestartException("cake");
        Assertions.assertEquals((Object)"Cannot start", (Object)e.getMessage());
        boolean b = e instanceof IllegalArgumentException;
        Assertions.assertTrue((boolean)b);
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("bar").toString());
        Assertions.assertEquals((int)10, (int)failures.size(), (String)"There should have 2 x 1 initial + 2 x 3 restart failure + 2 x 1 exhausted failures.");
        Assertions.assertEquals((int)6, (int)events.size(), (String)"There should have been 2 x 3 restart attempts.");
        Assertions.assertEquals((long)2L, (long)failures.stream().filter(failure -> failure.isExhausted()).count(), (String)("There should be 2 exhausted failure. Current state of failure list: " + this.getFailureStatus(failures)));
    }

    private String getFailureStatus(List<CamelEvent.RouteRestartingFailureEvent> failure) {
        StringBuilder sb = new StringBuilder();
        for (CamelEvent.RouteRestartingFailureEvent routeRestartingFailureEvent : failure) {
            sb.append("\nAttempt: " + routeRestartingFailureEvent.getAttempt());
            sb.append(", Is exhausted: " + routeRestartingFailureEvent.isExhausted());
            sb.append(", Cause: " + String.valueOf(routeRestartingFailureEvent.getCause()) != null ? routeRestartingFailureEvent.getCause().getMessage() : "No exception");
            sb.append(", timestamp: " + routeRestartingFailureEvent.getTimestamp());
        }
        return sb.toString();
    }

    @Test
    public void testSupervisingOk() throws Exception {
        this.context.addRoutes((RoutesBuilder)new MyRoute());
        SupervisingRouteController src = this.context.getRouteController().supervising();
        src.setBackOffDelay(25L);
        src.setBackOffMaxAttempts(10L);
        src.setInitialDelay(100L);
        src.setThreadPoolSize(2);
        final List failure = Collections.synchronizedList(new ArrayList());
        final List events = Collections.synchronizedList(new ArrayList());
        this.context.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

            public void notify(CamelEvent event) throws Exception {
                if (event instanceof CamelEvent.RouteRestartingFailureEvent) {
                    CamelEvent.RouteRestartingFailureEvent rfe = (CamelEvent.RouteRestartingFailureEvent)event;
                    failure.add(rfe);
                } else if (event instanceof RouteRestartingEvent) {
                    RouteRestartingEvent rre = (RouteRestartingEvent)event;
                    events.add(rre);
                }
            }
        });
        this.context.start();
        MockEndpoint mock = (MockEndpoint)this.context.getEndpoint("mock:foo", MockEndpoint.class);
        mock.expectedMinimumMessageCount(3);
        MockEndpoint mock2 = (MockEndpoint)this.context.getEndpoint("mock:cheese", MockEndpoint.class);
        mock2.expectedMessageCount(0);
        MockEndpoint mock3 = (MockEndpoint)this.context.getEndpoint("mock:cake", MockEndpoint.class);
        mock3.expectedMessageCount(0);
        MockEndpoint mock4 = (MockEndpoint)this.context.getEndpoint("mock:bar", MockEndpoint.class);
        mock4.expectedMessageCount(0);
        MockEndpoint.assertIsSatisfied((long)10L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{mock, mock2, mock3, mock4});
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").toString());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("cheese").toString());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("cake").toString());
        Assertions.assertEquals((Object)"Stopped", (Object)this.context.getRouteController().getRouteStatus("bar").toString());
        Assertions.assertEquals((int)10, (int)failure.size());
        Assertions.assertEquals((int)10, (int)events.size());
    }

    private static class MyRoute
    extends RouteBuilder {
        private MyRoute() {
        }

        public void configure() {
            this.getContext().addComponent("jms", (Component)new MyJmsComponent());
            ((RouteDefinition)this.from("timer:foo").to("mock:foo")).routeId("foo");
            ((RouteDefinition)this.from("jms:cheese").to("mock:cheese")).routeId("cheese");
            ((RouteDefinition)this.from("jms:cake").to("mock:cake")).routeId("cake");
            this.from("seda:bar").routeId("bar").autoStartup(false).to("mock:bar");
        }
    }

    private static class MyJmsConsumer
    extends SedaConsumer {
        private int counter;

        public MyJmsConsumer(SedaEndpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected void doStart() {
            if (this.counter++ < 5) {
                throw new IllegalArgumentException("Cannot start");
            }
        }
    }

    private static class MyJmsEndpoint
    extends SedaEndpoint {
        private final String name;

        public MyJmsEndpoint(String name) {
            this.name = name;
        }

        public Consumer createConsumer(Processor processor) {
            return new MyJmsConsumer(this, processor);
        }

        protected String createEndpointUri() {
            return "jms:" + this.name;
        }
    }

    private static class MyJmsComponent
    extends SedaComponent {
        private MyJmsComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyJmsEndpoint(remaining);
        }
    }
}

