/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.ByteArrayInputStream;
import java.net.URL;
import org.apache.camel.impl.engine.DefaultClassResolver;
import org.apache.camel.impl.engine.DefaultFactoryFinder;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Injector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultFactoryFinderTest {
    private static final String TEST_RESOURCE_PATH = "/org/apache/camel/impl/";
    final DefaultFactoryFinder factoryFinder = new DefaultFactoryFinder((ClassResolver)new DefaultClassResolver(), "/org/apache/camel/impl/");

    @Test
    public void shouldComplainIfClassResolverCannotResolveClass() {
        ClassResolver classResolver = (ClassResolver)Mockito.mock(ClassResolver.class);
        String properties = "class=" + TestImplA.class.getName();
        Mockito.when((Object)classResolver.loadResourceAsStream("/org/apache/camel/impl/TestImplA")).thenReturn((Object)new ByteArrayInputStream(properties.getBytes()));
        Mockito.when((Object)classResolver.resolveClass(TestImplA.class.getName())).thenReturn(null);
        DefaultFactoryFinder factoryFinder = new DefaultFactoryFinder(classResolver, TEST_RESOURCE_PATH);
        Assertions.assertFalse((boolean)factoryFinder.findClass("TestImplA").isPresent());
    }

    @Test
    public void shouldCacheFailedAttemptToResolveClass() {
        ClassResolver classResolver = (ClassResolver)Mockito.mock(ClassResolver.class);
        String properties = "class=" + TestImplA.class.getName();
        Mockito.when((Object)classResolver.loadResourceAsStream("/org/apache/camel/impl/TestImplA")).thenReturn((Object)new ByteArrayInputStream(properties.getBytes()));
        Mockito.when((Object)classResolver.resolveClass(TestImplA.class.getName())).thenReturn(null);
        DefaultFactoryFinder factoryFinder = new DefaultFactoryFinder(classResolver, TEST_RESOURCE_PATH);
        Assertions.assertFalse((boolean)factoryFinder.findClass("TestImplA").isPresent());
        Assertions.assertFalse((boolean)factoryFinder.findClass("TestImplA").isPresent());
        ((ClassResolver)Mockito.verify((Object)classResolver, (VerificationMode)Mockito.times((int)1))).resolveClass(TestImplA.class.getName());
    }

    @Test
    public void shouldComplainIfInstanceTypeIsNotAsExpected() {
        Injector injector = (Injector)Mockito.mock(Injector.class);
        TestImplA expected = new TestImplA();
        Mockito.when((Object)((TestImplA)injector.newInstance(TestImplA.class, false))).thenReturn((Object)expected);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.factoryFinder.newInstance("TestImplA", TestImplB.class), (String)"Exception should have been thrown");
        Assertions.assertInstanceOf(ClassCastException.class, (Object)e);
    }

    @Test
    public void shouldComplainIfUnableToCreateNewInstances() {
        Assertions.assertFalse((boolean)this.factoryFinder.newInstance("TestImplX").isPresent());
    }

    @Test
    public void shouldComplainNoClassKeyInPropertyFile() {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.factoryFinder.findClass("TestImplNoProperty"), (String)"NoFactoryAvailableException should have been thrown");
        Assertions.assertEquals((Object)"Expected property is missing: class", (Object)e.getCause().getMessage());
    }

    @Test
    public void shouldCreateNewInstances() {
        Object instance = this.factoryFinder.newInstance("TestImplA").get();
        Assertions.assertTrue((boolean)TestImplA.class.isInstance(instance));
    }

    @Test
    public void shouldFindSingleClass() {
        Class clazz = this.factoryFinder.findClass("TestImplA").orElse(null);
        Assertions.assertEquals(TestImplA.class, (Object)clazz);
    }

    URL urlFor(Class<?> clazz) {
        String resourceName = clazz.getPackage().getName().replace('.', '/') + "/" + clazz.getSimpleName() + ".properties";
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResource(resourceName);
    }

    public static class TestImplA
    implements TestType {
    }

    public static class TestImplB
    implements TestType {
    }

    public static interface TestType {
    }
}

