/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultCamelContextExtension;
import org.apache.camel.impl.engine.DefaultConfigurerResolver;
import org.apache.camel.impl.engine.SimpleCamelContext;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class DefaultConfigurerResolverTest {
    private DefaultConfigurerResolver resolver;
    private DefaultCamelContext ctx;

    DefaultConfigurerResolverTest() {
    }

    @BeforeEach
    public void setup() {
        this.resolver = new DefaultConfigurerResolver();
        this.ctx = new DefaultCamelContext();
    }

    @DisplayName(value="Test that the configurer uses the ContextConfigurer wrapper for the CamelContext and subclasses")
    @Test
    void resolvePropertyConfigurerShouldFallbackToDefaultConfigurer() {
        Stream.of(CamelContext.class.getName(), SimpleCamelContext.class.getName(), "org.apache.camel.model.ModelCamelContext", "org.apache.camel.SomeCamelContextStuff").forEach(name -> ((ObjectAssert)Assertions.assertThat((Object)this.resolver.resolvePropertyConfigurer(name, (CamelContext)this.ctx)).as(name, new Object[0])).isInstanceOf(DefaultConfigurerResolver.ContextConfigurer.class));
        Stream.of(DefaultCamelContextExtension.class.getName(), "org.apache.camel.SomeCamelContextStuffExtension").forEach(name -> ((ObjectAssert)Assertions.assertThat((Object)this.resolver.resolvePropertyConfigurer(name, (CamelContext)this.ctx)).as(name, new Object[0])).isNull());
    }

    @DisplayName(value="Test that the configurer defaults to null if given the extension (ContextConfiguration must be done via Context configurers)")
    @Test
    void resolvePropertyConfigurerForContextExtension() {
        this.resolver = new DefaultConfigurerResolver();
        DefaultCamelContext ctx = new DefaultCamelContext();
        Stream.of(DefaultCamelContextExtension.class.getName(), "org.apache.camel.SomeCamelContextStuffExtension").forEach(name -> ((ObjectAssert)Assertions.assertThat((Object)this.resolver.resolvePropertyConfigurer(name, (CamelContext)ctx)).as(name, new Object[0])).isNull());
    }

    @DisplayName(value="Test that the configurer returns null for classes named similarly, but unrelated to CamelContext")
    @Test
    void resolvePropertyConfigurerShouldFallbackToExtendedCamelContextOnlyForCamelComponents3() {
        Stream.of("CamelContext", "SimpleCamelContext", "org.somepackage.CamelContext", "it.apache.camel.ExtendedCamelContext").forEach(name -> ((ObjectAssert)Assertions.assertThat((Object)this.resolver.resolvePropertyConfigurer(name, (CamelContext)this.ctx)).as(name, new Object[0])).isNull());
    }
}

