/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.MyBean;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultCamelContextTest
extends TestSupport {
    @Test
    public void testStartDate() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        Assertions.assertNull((Object)CamelContextHelper.getStartDate((CamelContext)ctx));
        ctx.start();
        Assertions.assertNotNull((Object)CamelContextHelper.getStartDate((CamelContext)ctx));
    }

    @Test
    public void testAutoCreateComponentsOn() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Component component = ctx.getComponent("bean");
        Assertions.assertNotNull((Object)component);
        Assertions.assertEquals((Object)component.getClass(), BeanComponent.class);
    }

    @Test
    public void testAutoCreateComponentsOff() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.setAutoCreateComponents(false);
        Component component = ctx.getComponent("bean");
        Assertions.assertNull((Object)component);
    }

    @Test
    public void testAutoStartComponentsOff() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.start();
        BeanComponent component = (BeanComponent)ctx.getComponent("bean", true, false);
        Assertions.assertTrue((boolean)component.getStatus().isStopped());
    }

    @Test
    public void testAutoStartComponentsOn() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.disableJMX();
        ctx.start();
        BeanComponent component = (BeanComponent)ctx.getComponent("bean", true, true);
        Assertions.assertTrue((boolean)component.getStatus().isStarted());
    }

    @Test
    public void testCreateDefaultUuidGenerator() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.init();
        UuidGenerator uuidGenerator = ctx.getUuidGenerator();
        Assertions.assertNotNull((Object)uuidGenerator);
        Assertions.assertEquals((Object)uuidGenerator.getClass(), DefaultUuidGenerator.class);
    }

    @Test
    public void testGetComponents() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Component component = ctx.getComponent("bean");
        Assertions.assertNotNull((Object)component);
        Set names = ctx.getComponentNames();
        Assertions.assertEquals((int)1, (int)names.size());
        Assertions.assertEquals((Object)"bean", names.iterator().next());
    }

    @Test
    public void testGetEndpoint() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Endpoint endpoint = ctx.getEndpoint("log:foo");
        Assertions.assertNotNull((Object)endpoint);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ctx.getEndpoint(null), (String)"Should have thrown exception");
    }

    @Test
    public void testGetEndPointByTypeUnknown() {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        NoSuchEndpointException e = (NoSuchEndpointException)Assertions.assertThrows(NoSuchEndpointException.class, () -> camelContext.getEndpoint("xxx", Endpoint.class));
        Assertions.assertEquals((Object)"No endpoint could be found for: xxx, please check your classpath contains the needed Camel component jar.", (Object)e.getMessage());
    }

    @Test
    public void testRemoveEndpoint() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.getEndpoint("log:foo");
        ctx.getEndpoint("log:bar");
        ctx.start();
        Collection list = ctx.removeEndpoints("log:foo");
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertEquals((Object)"log://foo", (Object)((Endpoint)list.iterator().next()).getEndpointUri());
        ctx.getEndpoint("log:baz");
        ctx.getEndpoint("seda:cool");
        list = ctx.removeEndpoints("log:*");
        Assertions.assertEquals((int)2, (int)list.size());
        Iterator it = list.iterator();
        String s1 = ((Endpoint)it.next()).getEndpointUri();
        String s2 = ((Endpoint)it.next()).getEndpointUri();
        Assertions.assertTrue(("log://bar".equals(s1) || "log://bar".equals(s2) ? 1 : 0) != 0);
        Assertions.assertTrue(("log://baz".equals(s1) || "log://baz".equals(s2) ? 1 : 0) != 0);
        Assertions.assertTrue(("log://baz".equals(s1) || "log://baz".equals(s2) ? 1 : 0) != 0);
        Assertions.assertTrue(("log://baz".equals(s1) || "log://baz".equals(s2) ? 1 : 0) != 0);
        Assertions.assertEquals((int)1, (int)ctx.getEndpoints().size());
    }

    @Test
    public void testGetEndpointNotFound() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        NoSuchEndpointException e = (NoSuchEndpointException)Assertions.assertThrows(NoSuchEndpointException.class, () -> ctx.getEndpoint("xxx:foo"), (String)"Should have thrown a ResolveEndpointFailedException");
        Assertions.assertTrue((boolean)e.getMessage().contains("No endpoint could be found for: xxx:"));
    }

    @Test
    public void testGetEndpointUnknownComponentNoScheme() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Assertions.assertThrows(NoSuchEndpointException.class, () -> CamelContextHelper.getMandatoryEndpoint((CamelContext)ctx, (String)"unknownname"), (String)"Should have thrown a NoSuchEndpointException");
    }

    @Test
    public void testRestartCamelContext() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:endpointA").to("mock:endpointB");
            }
        });
        ctx.start();
        Assertions.assertEquals((int)1, (int)ctx.getRouteServices().size(), (String)"Should have one RouteService");
        String routesString = ctx.getRoutes().toString();
        ctx.stop();
        Assertions.assertEquals((int)1, (int)ctx.getRouteServices().size(), (String)"The RouteService should NOT be removed even when we stop");
        ctx.start();
        Assertions.assertEquals((int)1, (int)ctx.getRouteServices().size(), (String)"Should have one RouteService");
        Assertions.assertEquals((Object)routesString, (Object)ctx.getRoutes().toString(), (String)"The Routes should be same");
        ctx.stop();
        Assertions.assertEquals((int)1, (int)ctx.getRouteServices().size(), (String)"The RouteService should NOT be removed even when we stop");
    }

    @Test
    public void testName() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.init();
        Assertions.assertNotNull((Object)ctx.getName(), (String)"Should have a default name");
        ctx.getCamelContextExtension().setName("foo");
        Assertions.assertEquals((Object)"foo", (Object)ctx.getName());
        Assertions.assertNotNull((Object)ctx.toString());
        Assertions.assertTrue((boolean)ctx.isAutoStartup());
    }

    @Test
    public void testVersion() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Assertions.assertNotNull((Object)ctx.getVersion(), (String)"Should have a version");
    }

    @Test
    public void testHasComponent() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Assertions.assertNull((Object)ctx.hasComponent("log"));
        ctx.addComponent("log", (Component)new LogComponent());
        Assertions.assertNotNull((Object)ctx.hasComponent("log"));
    }

    @Test
    public void testGetComponent() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.addComponent("log", (Component)new LogComponent());
        LogComponent log = (LogComponent)ctx.getComponent("log", LogComponent.class);
        Assertions.assertNotNull((Object)log);
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ctx.addComponent("direct", (Component)new DirectComponent());
            ctx.getComponent("log", DirectComponent.class);
        }, (String)"Should have thrown exception");
    }

    @Test
    public void testHasEndpoint() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.getEndpoint("mock://foo");
        Assertions.assertNotNull((Object)ctx.hasEndpoint("mock://foo"));
        Assertions.assertNull((Object)ctx.hasEndpoint("mock://bar"));
        EndpointRegistry map = ctx.getEndpointRegistry();
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertThrows(ResolveEndpointFailedException.class, () -> ctx.hasEndpoint(null), (String)"Should have thrown exception");
    }

    @Test
    public void testGetRouteById() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Route route = ctx.getRoute("coolRoute");
        Assertions.assertNull((Object)route);
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("coolRoute").to("mock:result");
            }
        });
        ctx.start();
        route = ctx.getRoute("coolRoute");
        Assertions.assertNotNull((Object)route);
        Assertions.assertEquals((Object)"coolRoute", (Object)route.getId());
        Assertions.assertEquals((Object)"direct://start", (Object)route.getConsumer().getEndpoint().getEndpointUri());
        Assertions.assertNull((Object)ctx.getRoute("unknown"));
        ctx.stop();
    }

    @Test
    public void testSuspend() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.start();
        Assertions.assertTrue((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.suspend();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertTrue((boolean)ctx.isSuspended());
        ctx.suspend();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertTrue((boolean)ctx.isSuspended());
        ctx.stop();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
    }

    @Test
    public void testResume() {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.start();
        Assertions.assertTrue((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.resume();
        Assertions.assertTrue((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.resume();
        Assertions.assertTrue((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.stop();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
    }

    @Test
    public void testSuspendResume() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.start();
        Assertions.assertTrue((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.suspend();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertTrue((boolean)ctx.isSuspended());
        ctx.resume();
        Assertions.assertTrue((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
        ctx.stop();
        Assertions.assertFalse((boolean)ctx.isStarted());
        Assertions.assertFalse((boolean)ctx.isSuspended());
    }

    @Test
    public void testAddServiceInjectCamelContext() throws Exception {
        MyService my = new MyService();
        DefaultCamelContext ctx = new DefaultCamelContext();
        ctx.addService((Object)my);
        ctx.start();
        Assertions.assertEquals((Object)ctx, (Object)my.getCamelContext());
        Assertions.assertEquals((Object)"Started", (Object)my.getStatus().name());
        ctx.stop();
        Assertions.assertEquals((Object)"Stopped", (Object)my.getStatus().name());
    }

    @Test
    public void testAddServiceType() throws Exception {
        MyService my = new MyService();
        DefaultCamelContext ctx = new DefaultCamelContext();
        Assertions.assertNull((Object)ctx.hasService(MyService.class));
        ctx.addService((Object)my);
        Assertions.assertSame((Object)((Object)my), (Object)ctx.hasService(MyService.class));
        ctx.stop();
        Assertions.assertNull((Object)ctx.hasService(MyService.class));
    }

    @Test
    public void testRemoveRoute() throws Exception {
        DefaultCamelContext ctx = new DefaultCamelContext(false);
        ctx.disableJMX();
        ctx.getRegistry().bind("MyBean", MyBean.class);
        ctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("rawRoute").to("bean:MyBean?method=RAW(addString('aa a',${body}))");
            }
        });
        ctx.start();
        EndpointRegistry endpoints = ctx.getEndpointRegistry();
        Map routeServices = ctx.getRouteServices();
        Set routeEndpoints = ((RouteService)routeServices.get("rawRoute")).gatherEndpoints();
        for (Endpoint endpoint : routeEndpoints) {
            Endpoint oldEndpoint = (Endpoint)endpoints.remove((Object)ctx.getEndpointKey(endpoint.getEndpointUri()));
            if (oldEndpoint == null) {
                String decodeUri = URISupport.getDecodeQuery((String)endpoint.getEndpointUri());
                oldEndpoint = (Endpoint)endpoints.remove((Object)ctx.getEndpointKey(decodeUri));
            } else {
                Assertions.assertNotNull((Object)oldEndpoint);
            }
            Assertions.assertNotNull((Object)oldEndpoint);
        }
    }

    private static class MyService
    extends ServiceSupport
    implements CamelContextAware {
        private CamelContext camelContext;

        private MyService() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }
    }
}

