/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.engine.DefaultExecutorServiceManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.support.DefaultThreadPoolFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CustomThreadPoolFactoryTest
extends ContextTestSupport {
    private final MyCustomThreadPoolFactory factory = new MyCustomThreadPoolFactory();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        DefaultExecutorServiceManager executorServiceManager = new DefaultExecutorServiceManager(context);
        executorServiceManager.setThreadPoolFactory((ThreadPoolFactory)this.factory);
        context.setExecutorServiceManager((ExecutorServiceManager)executorServiceManager);
        return context;
    }

    @Test
    public void testCustomThreadPoolFactory() {
        this.context.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "foo");
        Assertions.assertTrue((boolean)this.factory.isInvoked(), (String)"Should use custom thread pool factory");
    }

    public static final class MyCustomThreadPoolFactory
    extends DefaultThreadPoolFactory {
        private volatile boolean invoked;

        public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
            this.invoked = true;
            return super.newCachedThreadPool(threadFactory);
        }

        public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, boolean allowCoreThreadTimeOut, RejectedExecutionHandler rejectedExecutionHandler, ThreadFactory threadFactory) throws IllegalArgumentException {
            this.invoked = true;
            return super.newThreadPool(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, maxQueueSize, allowCoreThreadTimeOut, rejectedExecutionHandler, threadFactory);
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }
}

