/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.BeanConfigInject;
import org.apache.camel.BeanInject;
import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Produce;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.FooBar;
import org.apache.camel.impl.FooBarConfig;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CamelPostProcessorHelperTest
extends ContextTestSupport {
    private final MySynchronization mySynchronization = new MySynchronization();
    private final Properties myProp = new Properties();

    @Override
    protected Registry createCamelRegistry() {
        DefaultRegistry jndi = new DefaultRegistry();
        jndi.bind("myProp", (Object)this.myProp);
        jndi.bind("foo", (Object)new FooBar());
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getPropertiesComponent().setLocation("ref:myProp");
        return context;
    }

    @Test
    public void testConstructor() {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper();
        Assertions.assertNull((Object)helper.getCamelContext());
        helper.setCamelContext((CamelContext)this.context);
        Assertions.assertNotNull((Object)helper.getCamelContext());
    }

    @Test
    public void testConstructorCamelContext() {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        Assertions.assertNotNull((Object)helper.getCamelContext());
    }

    @Test
    public void testConsume() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        Method method = my.getClass().getMethod("consumeSomething", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConsumePrivate() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPrivateConsumeBean my = new MyPrivateConsumeBean();
        Method method = my.getClass().getDeclaredMethod("consumeSomethingPrivate", String.class);
        RuntimeCamelException e = (RuntimeCamelException)Assertions.assertThrows(RuntimeCamelException.class, () -> helper.consumerInjection(method, (Object)my, "foo"), (String)"Should have thrown exception");
        IllegalArgumentException iae = CamelPostProcessorHelperTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertTrue((boolean)iae.getMessage().startsWith("The method private void"));
        Assertions.assertTrue((boolean)iae.getMessage().endsWith("(for example the method must be public)"));
    }

    @Test
    public void testConsumeSynchronization() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeAndSynchronizationBean my = new MyConsumeAndSynchronizationBean();
        Method method = my.getClass().getMethod("consumeSomething", String.class, Exchange.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await((String)"onDone invokation").atMost(1L, TimeUnit.SECONDS).until(this.mySynchronization::isOnDone);
    }

    @Test
    public void testProduceSynchronization() throws Exception {
        MyProduceAndSynchronizationBean my = new MyProduceAndSynchronizationBean();
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        Producer producer = helper.createInjectionProducer(this.context.getEndpoint("mock:result"), (Object)my, "foo");
        my.setProducer(producer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        my.produceSomething("Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await((String)"onDone invocation").atMost(1L, TimeUnit.SECONDS).until(this.mySynchronization::isOnDone);
    }

    @Test
    public void testEndpointInjectProducerTemplate() throws Exception {
        Class<?>[] parameterTypes;
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectBeanProducerTemplate bean = new MyEndpointInjectBeanProducerTemplate();
        Method method = bean.getClass().getMethod("setProducer", ProducerTemplate.class);
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        for (Class<?> type : parameterTypes = method.getParameterTypes()) {
            String propertyName = org.apache.camel.util.ObjectHelper.getPropertyName((Method)method);
            Object value = helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo");
            ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Assertions.assertNotNull((Object)bean.getProducer());
        bean.send("Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointInjectProducer() throws Exception {
        Class<?>[] parameterTypes;
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointBeanProducer bean = new MyEndpointBeanProducer();
        Method method = bean.getClass().getMethod("setProducer", Producer.class);
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        for (Class<?> type : parameterTypes = method.getParameterTypes()) {
            String propertyName = org.apache.camel.util.ObjectHelper.getPropertyName((Method)method);
            Object value = helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo");
            ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Assertions.assertNotNull((Object)bean.getProducer());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointInjectPollingConsumer() throws Exception {
        Class<?>[] parameterTypes;
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointBeanPollingConsumer bean = new MyEndpointBeanPollingConsumer();
        Method method = bean.getClass().getMethod("setConsumer", PollingConsumer.class);
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        for (Class<?> type : parameterTypes = method.getParameterTypes()) {
            String propertyName = org.apache.camel.util.ObjectHelper.getPropertyName((Method)method);
            Object value = helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo");
            ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
        this.template.sendBody("seda:foo", (Object)"Hello World");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Assertions.assertNotNull((Object)bean.getConsumer());
        Exchange exchange = bean.consume();
        this.template.send("mock:result", exchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointInjectProducerTemplateField() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplate bean = new MyEndpointInjectProducerTemplate();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        Object value = helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo");
        field.set(bean, value);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointInjectFluentProducerTemplateField() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectFluentProducerTemplate bean = new MyEndpointInjectFluentProducerTemplate();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        Object value = helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo");
        field.set(bean, value);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointInjectProducerTemplateFieldNoDefaultEndpoint() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplateNoDefaultEndpoint bean = new MyEndpointInjectProducerTemplateNoDefaultEndpoint();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        Object value = helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo");
        field.set(bean, value);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testEndpointInjectProducerTemplateFieldNameUnknown() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplateNameUnknown bean = new MyEndpointInjectProducerTemplateNameUnknown();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        ResolveEndpointFailedException e = (ResolveEndpointFailedException)Assertions.assertThrows(ResolveEndpointFailedException.class, () -> helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo"), (String)"Should throw exception");
        Assertions.assertEquals((Object)"ref://unknown", (Object)e.getUri());
        NoSuchBeanException nsbe = CamelPostProcessorHelperTest.assertIsInstanceOf(NoSuchBeanException.class, e.getCause());
        Assertions.assertEquals((Object)"No bean could be found in the registry for: unknown of type: org.apache.camel.Endpoint", (Object)nsbe.getMessage());
    }

    @Test
    public void testEndpointInjectProducerTemplateFieldUrlUnknown() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplateUrlUnknown bean = new MyEndpointInjectProducerTemplateUrlUnknown();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        Assertions.assertThrows(NoSuchEndpointException.class, () -> helper.getInjectionValue(type, endpointInject.value(), endpointInject.property(), propertyName, (Object)bean, "foo"), (String)"Should throw exception");
    }

    @Test
    public void testPropertyFieldInject() throws Exception {
        this.myProp.put("myTimeout", "2000");
        this.myProp.put("myApp", "Camel");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldBean bean = new MyPropertyFieldBean();
        Field field = bean.getClass().getField("timeout");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", "");
        Assertions.assertEquals((Object)2000, (Object)Integer.valueOf(String.valueOf(value)));
        field = bean.getClass().getField("greeting");
        propertyInject = field.getAnnotation(PropertyInject.class);
        type = field.getType();
        value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", "");
        Assertions.assertEquals((Object)"Hello Camel", (Object)value);
    }

    @Test
    public void testPropertyFieldDefaultValueInject() throws Exception {
        this.myProp.put("myApp", "Camel");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldBean bean = new MyPropertyFieldBean();
        Field field = bean.getClass().getField("timeout");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "5000", "");
        Assertions.assertEquals((Object)5000, (Object)Integer.valueOf(String.valueOf(value)));
        field = bean.getClass().getField("greeting");
        propertyInject = field.getAnnotation(PropertyInject.class);
        type = field.getType();
        value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", "");
        Assertions.assertEquals((Object)"Hello Camel", (Object)value);
    }

    @Test
    public void testPropertyFieldSeparatorArrayInject() throws Exception {
        this.myProp.put("serverPorts", "4444;5555");
        this.myProp.put("hosts", "serverA , serverB");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldSeparatorArrayBean bean = new MyPropertyFieldSeparatorArrayBean();
        Field field = bean.getClass().getField("ports");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", propertyInject.separator());
        CamelPostProcessorHelperTest.assertIsInstanceOf(int[].class, value);
        int[] arr = (int[])value;
        Assertions.assertEquals((int)2, (int)arr.length);
        Assertions.assertEquals((int)4444, (int)arr[0]);
        Assertions.assertEquals((int)5555, (int)arr[1]);
        field = bean.getClass().getField("hosts");
        propertyInject = field.getAnnotation(PropertyInject.class);
        type = field.getType();
        value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", propertyInject.separator());
        CamelPostProcessorHelperTest.assertIsInstanceOf(String[].class, value);
        String[] arr2 = (String[])value;
        Assertions.assertEquals((int)2, (int)arr2.length);
        Assertions.assertEquals((Object)"serverA", (Object)arr2[0]);
        Assertions.assertEquals((Object)"serverB", (Object)arr2[1]);
    }

    @Test
    public void testPropertyFieldSeparatorListInject() throws Exception {
        this.myProp.put("serverPorts", "4444;5555");
        this.myProp.put("hosts", "serverA , serverB");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldSeparatorListBean bean = new MyPropertyFieldSeparatorListBean();
        Field field = bean.getClass().getField("ports");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, field.getGenericType(), propertyInject.value(), "", propertyInject.separator());
        CamelPostProcessorHelperTest.assertIsInstanceOf(List.class, value);
        List arr = (List)value;
        Assertions.assertEquals((int)2, (int)arr.size());
        Assertions.assertEquals((Object)4444, arr.get(0));
        Assertions.assertEquals((Object)5555, arr.get(1));
        field = bean.getClass().getField("hosts");
        propertyInject = field.getAnnotation(PropertyInject.class);
        type = field.getType();
        value = helper.getInjectionPropertyValue(type, field.getGenericType(), propertyInject.value(), "", propertyInject.separator());
        CamelPostProcessorHelperTest.assertIsInstanceOf(Set.class, value);
        Set arr2 = (Set)value;
        Assertions.assertEquals((int)2, (int)arr.size());
        Iterator it = arr2.iterator();
        Assertions.assertEquals((Object)"serverA", it.next());
        Assertions.assertEquals((Object)"serverB", it.next());
    }

    @Test
    public void testPropertyFieldSeparatorMapInject() throws Exception {
        this.myProp.put("servers", "serverA = 4444 ; serverB=5555");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldSeparatorMapBean bean = new MyPropertyFieldSeparatorMapBean();
        Field field = bean.getClass().getField("servers");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, field.getGenericType(), propertyInject.value(), "", propertyInject.separator());
        CamelPostProcessorHelperTest.assertIsInstanceOf(Map.class, value);
        Map arr = (Map)value;
        Assertions.assertEquals((int)2, (int)arr.size());
        Assertions.assertEquals((Object)4444, arr.get("serverA"));
        Assertions.assertEquals((Object)5555, arr.get("serverB"));
    }

    @Test
    public void testPropertyMethodInject() throws Exception {
        this.myProp.put("myTimeout", "2000");
        this.myProp.put("myApp", "Camel");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyMethodBean bean = new MyPropertyMethodBean();
        Method method = bean.getClass().getMethod("setTimeout", Integer.TYPE);
        PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
        Class<?> type = method.getParameterTypes()[0];
        Object value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", "");
        Assertions.assertEquals((Object)2000, (Object)Integer.valueOf(String.valueOf(value)));
        method = bean.getClass().getMethod("setGreeting", String.class);
        propertyInject = method.getAnnotation(PropertyInject.class);
        type = method.getParameterTypes()[0];
        value = helper.getInjectionPropertyValue(type, null, propertyInject.value(), "", "");
        Assertions.assertEquals((Object)"Hello Camel", (Object)value);
    }

    @Test
    public void testBeanInject() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyBeanInjectBean bean = new MyBeanInjectBean();
        Field field = bean.getClass().getField("foo");
        BeanInject beanInject = field.getAnnotation(BeanInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionBeanValue(type, beanInject.value());
        field.set(bean, value);
        String out = bean.doSomething("World");
        Assertions.assertEquals((Object)"Hello World", (Object)out);
    }

    @Test
    public void testBeanInjectNotFound() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyBeanInjectBean bean = new MyBeanInjectBean();
        Field field = bean.getClass().getField("foo");
        Class<?> type = field.getType();
        NoSuchBeanException e = (NoSuchBeanException)Assertions.assertThrows(NoSuchBeanException.class, () -> helper.getInjectionBeanValue(type, "bar"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"No bean could be found in the registry for: bar of type: org.apache.camel.impl.FooBar", (Object)e.getMessage());
        Assertions.assertEquals((Object)"bar", (Object)e.getName());
    }

    @Test
    public void testBeanInjectByType() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyBeanInjectByTypeBean bean = new MyBeanInjectByTypeBean();
        Field field = bean.getClass().getField("foo");
        BeanInject beanInject = field.getAnnotation(BeanInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionBeanValue(type, beanInject.value());
        field.set(bean, value);
        String out = bean.doSomething("Camel");
        Assertions.assertEquals((Object)"Hello Camel", (Object)out);
    }

    @Test
    public void testBeanConfigInjectByType() throws Exception {
        Properties initial = new Properties();
        initial.put("foobar.name", "Donald");
        initial.put("foobar.age", "33");
        this.context.getPropertiesComponent().setInitialProperties(initial);
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyBeanConfigInjectByTypeBean bean = new MyBeanConfigInjectByTypeBean();
        Field field = bean.getClass().getField("config");
        BeanConfigInject beanInject = field.getAnnotation(BeanConfigInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionBeanConfigValue(type, beanInject.value());
        field.set(bean, value);
        String out = bean.doSomething("Camel");
        Assertions.assertEquals((Object)"Donald (age: 33) likes Camel", (Object)out);
    }

    @Test
    public void testBeanConfigInjectByMethod() throws Exception {
        Properties initial = new Properties();
        initial.put("foobar.name", "Goofy");
        initial.put("foobar.age", "34");
        this.context.getPropertiesComponent().setInitialProperties(initial);
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyBeanConfigInjectByMethod bean = new MyBeanConfigInjectByMethod();
        Method method = bean.getClass().getMethod("initFooBar", FooBarConfig.class);
        BeanConfigInject beanInject = method.getAnnotation(BeanConfigInject.class);
        Class<?> type = method.getParameterTypes()[0];
        Object value = helper.getInjectionBeanConfigValue(type, beanInject.value());
        method.invoke((Object)bean, value);
        String out = bean.doSomething("Camel");
        Assertions.assertEquals((Object)"Goofy (age: 34) likes Camel", (Object)out);
    }

    @Test
    public void testFluentProducerTemplateWithNoInjection() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        NoBeanInjectionTestClass myBean = new NoBeanInjectionTestClass();
        Field field = myBean.getClass().getField("fluentProducerTemplate");
        EndpointInject inject = field.getAnnotation(EndpointInject.class);
        String propertyName = "fluent";
        Class<?> classType = field.getType();
        Object value = helper.getInjectionValue(classType, inject.value(), inject.property(), propertyName, (Object)myBean, "bla");
        field.set(myBean, value);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bla Bla Bla. ."});
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Bla Bla Bla. .");
        myBean.sendExchange((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    private static class MySynchronization
    extends SynchronizationAdapter {
        private boolean onDone;

        private MySynchronization() {
        }

        public void onDone(Exchange exchange) {
            this.onDone = true;
        }

        public boolean isOnDone() {
            return this.onDone;
        }
    }

    public class MyConsumeBean {
        @Consume(value="seda:foo")
        public void consumeSomething(String body) {
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            CamelPostProcessorHelperTest.this.template.sendBody("mock:result", (Object)body);
        }
    }

    public class MyPrivateConsumeBean {
        @Consume(value="seda:foo")
        private void consumeSomethingPrivate(String body) {
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            CamelPostProcessorHelperTest.this.template.sendBody("mock:result", (Object)body);
        }
    }

    public class MyConsumeAndSynchronizationBean {
        @Consume(value="seda:foo")
        public void consumeSomething(String body, Exchange exchange) {
            exchange.getExchangeExtension().addOnCompletion((Synchronization)CamelPostProcessorHelperTest.this.mySynchronization);
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            CamelPostProcessorHelperTest.this.template.sendBody("mock:result", (Object)body);
        }
    }

    public class MyProduceAndSynchronizationBean {
        @Produce(value="mock:result")
        Producer producer;

        public void produceSomething(String body) throws Exception {
            Assertions.assertEquals((Object)"Hello World", (Object)body);
            Exchange exchange = this.producer.getEndpoint().createExchange();
            exchange.getExchangeExtension().addOnCompletion((Synchronization)CamelPostProcessorHelperTest.this.mySynchronization);
            exchange.getIn().setBody((Object)body);
            this.producer.process(exchange);
        }

        public void setProducer(Producer producer) {
            this.producer = producer;
        }
    }

    public static class MyEndpointInjectBeanProducerTemplate {
        private ProducerTemplate producer;

        @EndpointInject(value="mock:result")
        public void setProducer(ProducerTemplate producer) {
            this.producer = producer;
        }

        public ProducerTemplate getProducer() {
            return this.producer;
        }

        public void send(String message) {
            this.producer.sendBody((Object)message);
        }
    }

    public static class MyEndpointBeanProducer {
        private Producer producer;

        @EndpointInject(value="mock:result")
        public void setProducer(Producer producer) {
            this.producer = producer;
        }

        public Producer getProducer() {
            return this.producer;
        }

        public void send(Exchange exchange) throws Exception {
            this.producer.process(exchange);
        }
    }

    public static class MyEndpointBeanPollingConsumer {
        private PollingConsumer consumer;

        @EndpointInject(value="seda:foo")
        public void setConsumer(PollingConsumer consumer) {
            this.consumer = consumer;
        }

        public PollingConsumer getConsumer() {
            return this.consumer;
        }

        public Exchange consume() {
            return this.consumer.receive(1000L);
        }
    }

    public static class MyEndpointInjectProducerTemplate {
        @EndpointInject(value="mock:result")
        public ProducerTemplate producer;

        public void send(Exchange exchange) {
            this.producer.send(exchange);
        }
    }

    public static class MyEndpointInjectFluentProducerTemplate {
        @EndpointInject(value="mock:result")
        public FluentProducerTemplate producer;

        public void send(Exchange exchange) {
            this.producer.withExchange(exchange).send();
        }
    }

    public static class MyEndpointInjectProducerTemplateNoDefaultEndpoint {
        @EndpointInject
        public ProducerTemplate producer;

        public void send(Exchange exchange) {
            this.producer.send("mock:result", exchange);
        }
    }

    public static class MyEndpointInjectProducerTemplateNameUnknown {
        @EndpointInject(value="ref:unknown")
        public ProducerTemplate producer;

        public void send(Exchange exchange) {
            this.producer.send(exchange);
        }
    }

    public static class MyEndpointInjectProducerTemplateUrlUnknown {
        @EndpointInject(value="xxx:foo")
        public ProducerTemplate producer;

        public void send(Exchange exchange) {
            this.producer.send(exchange);
        }
    }

    public static class MyPropertyFieldBean {
        @PropertyInject(value="myTimeout")
        public int timeout;
        @PropertyInject(value="Hello {{myApp}}")
        public String greeting;

        public String doSomething(String body) {
            return this.greeting + " " + body + " with timeout=" + this.timeout;
        }
    }

    public static class MyPropertyFieldSeparatorArrayBean {
        @PropertyInject(value="serverPorts", separator=";")
        public int[] ports;
        @PropertyInject(value="hosts", separator=",")
        public String[] hosts;

        public String doSomething(String body) {
            return String.format("%s:%d %s:%d with body: %s", this.hosts[0], this.ports[0], this.hosts[1], this.ports[1], body);
        }
    }

    public static class MyPropertyFieldSeparatorListBean {
        @PropertyInject(value="serverPorts", separator=";")
        public List<Integer> ports;
        @PropertyInject(value="hosts", separator=",")
        public Set<String> hosts;

        public String doSomething(String body) {
            Iterator<String> it = this.hosts.iterator();
            return String.format("%s:%d %s:%d with body: %s", it.next(), this.ports.get(0), it.next(), this.ports.get(1), body);
        }
    }

    public static class MyPropertyFieldSeparatorMapBean {
        @PropertyInject(value="servers", separator=";")
        public Map<String, Integer> servers;

        public String doSomething(String body) {
            return null;
        }
    }

    public static class MyPropertyMethodBean {
        private int timeout;
        private String greeting;

        public String doSomething(String body) {
            return this.greeting + " " + body + " with timeout=" + this.timeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        @PropertyInject(value="myTimeout")
        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public String getGreeting() {
            return this.greeting;
        }

        @PropertyInject(value="Hello {{myApp}}")
        public void setGreeting(String greeting) {
            this.greeting = greeting;
        }
    }

    public static class MyBeanInjectBean {
        @BeanInject(value="foo")
        public FooBar foo;

        public String doSomething(String body) {
            return this.foo.hello(body);
        }
    }

    public static class MyBeanInjectByTypeBean {
        @BeanInject
        public FooBar foo;

        public String doSomething(String body) {
            return this.foo.hello(body);
        }
    }

    public static class MyBeanConfigInjectByTypeBean {
        @BeanConfigInject(value="foobar")
        public FooBarConfig config;

        public String doSomething(String body) {
            FooBar bean = new FooBar();
            bean.setGreeting(this.config.getName() + " (age: " + this.config.getAge() + ") likes");
            return bean.hello(body);
        }
    }

    public static class MyBeanConfigInjectByMethod {
        public FooBar fooBar;

        @BeanConfigInject(value="foobar")
        public void initFooBar(FooBarConfig config) {
            this.fooBar = new FooBar();
            this.fooBar.setGreeting(config.getName() + " (age: " + config.getAge() + ") likes");
        }

        public String doSomething(String body) {
            return this.fooBar.hello(body);
        }
    }

    public static class NoBeanInjectionTestClass {
        @EndpointInject
        public FluentProducerTemplate fluentProducerTemplate;

        public void sendExchange(Exchange exchange) {
            this.fluentProducerTemplate.withExchange(exchange).to("mock:result").send();
        }
    }

    public static class MyPropertyFieldDefaultValueBean {
        @PropertyInject(value="myTimeout", defaultValue="5000")
        public int timeout;
        @PropertyInject(value="Hello {{myApp}}")
        public String greeting;

        public String doSomething(String body) {
            return this.greeting + " " + body + " with timeout=" + this.timeout;
        }
    }
}

