/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.engine.CamelPostProcessorHelper;
import org.junit.jupiter.api.Test;

public class CamelPostProcessorHelperConsumePredicateTest
extends ContextTestSupport {
    @Test
    public void testConsumePredicate() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        Method method = my.getClass().getMethod("low", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        method = my.getClass().getMethod("high", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        this.getMockEndpoint("mock:low").expectedBodiesReceived(new Object[]{"17", "89", "39"});
        this.getMockEndpoint("mock:high").expectedBodiesReceived(new Object[]{"219", "112"});
        this.template.sendBody("direct:foo", (Object)"17");
        this.template.sendBody("direct:foo", (Object)"219");
        this.template.sendBody("direct:foo", (Object)"89");
        this.template.sendBody("direct:foo", (Object)"112");
        this.template.sendBody("direct:foo", (Object)"39");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConsumePredicateDrop() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        Method method = my.getClass().getMethod("low", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        method = my.getClass().getMethod("high", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        this.getMockEndpoint("mock:low").expectedBodiesReceived(new Object[]{"17"});
        this.getMockEndpoint("mock:high").expectedBodiesReceived(new Object[]{"112"});
        this.template.sendBody("direct:foo", (Object)"17");
        this.template.sendBody("direct:foo", (Object)"-1");
        this.template.sendBody("direct:foo", (Object)"112");
        this.assertMockEndpointsSatisfied();
    }

    public class MyConsumeBean {
        @Consume(value="direct:foo", predicate="${body} >= 0 && ${body} < 100")
        public void low(String body) {
            CamelPostProcessorHelperConsumePredicateTest.this.template.sendBody("mock:low", (Object)body);
        }

        @Consume(value="direct:foo", predicate="${body} >= 100")
        public void high(String body) {
            CamelPostProcessorHelperConsumePredicateTest.this.template.sendBody("mock:high", (Object)body);
        }
    }
}

