/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.TypeResolverHelper;
import org.apache.camel.spi.TypeConvertible;
import org.apache.camel.support.SimpleTypeConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class TypeResolverHelperTest {
    private static final Map<TypeConvertible<?, ?>, TypeConverter> registeredConverters = new HashMap();

    TypeResolverHelperTest() {
    }

    @BeforeAll
    static void setUp() {
        registeredConverters.put(new TypeConvertible(Source.class, Child.class), (TypeConverter)new SourceChildConverter());
    }

    @Test
    public void testTryAssignableToChild() {
        TypeConvertible requestedConverter = new TypeConvertible(Source.class, Child.class);
        TypeConverter foundConverter = TypeResolverHelper.tryAssignableFrom((TypeConvertible)requestedConverter, registeredConverters);
        Assertions.assertNotNull((Object)foundConverter);
        Child result = (Child)foundConverter.tryConvertTo(Child.class, (Object)new Source("source"));
        Assertions.assertEquals((Object)"sourceP", (Object)result.parentField);
        Assertions.assertEquals((Object)"sourceC", (Object)result.childField);
    }

    @Test
    public void testTryAssignableToParent() {
        TypeConvertible requestedConverter = new TypeConvertible(Source.class, Parent.class);
        TypeConverter foundConverter = TypeResolverHelper.tryAssignableFrom((TypeConvertible)requestedConverter, registeredConverters);
        Assertions.assertNotNull((Object)foundConverter);
        Parent result = (Parent)foundConverter.tryConvertTo(Parent.class, (Object)new Source("source"));
        Assertions.assertEquals((Object)"sourceP", (Object)result.parentField);
    }

    private static class Source {
        final String sourceField;

        private Source(String sourceField) {
            this.sourceField = sourceField;
        }
    }

    private static class Child
    extends Parent {
        final String childField;

        private Child(String parentField, String childField) {
            super(parentField);
            this.childField = childField;
        }
    }

    private static class SourceChildConverter
    extends SimpleTypeConverter {
        private SourceChildConverter() {
            super(true, (type, exchange, value) -> {
                Source source = (Source)value;
                return new Child(source.sourceField + "P", source.sourceField + "C");
            });
        }
    }

    private static class Parent {
        final String parentField;

        private Parent(String parentField) {
            this.parentField = parentField;
        }
    }
}

