/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.impl.converter.Country;
import org.apache.camel.impl.converter.MyConverters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeConvertersTest
extends ContextTestSupport {
    private final MyConverters converters = new MyConverters();

    @Test
    public void testAdd() {
        int before = this.context.getTypeConverterRegistry().size();
        this.context.getTypeConverterRegistry().addTypeConverters((Object)this.converters);
        int after = this.context.getTypeConverterRegistry().size();
        int delta = after - before;
        Assertions.assertEquals((int)2, (int)delta, (String)"There should be 2 more type converters");
        Country country = (Country)this.context.getTypeConverter().convertTo(Country.class, (Object)"en");
        Assertions.assertNotNull((Object)country);
        Assertions.assertEquals((Object)"England", (Object)country.getName());
        String iso = (String)this.context.getTypeConverter().convertTo(String.class, (Object)country);
        Assertions.assertNotNull((Object)iso);
        Assertions.assertEquals((Object)"en", (Object)iso);
    }

    @Test
    public void testStringToPrimitiveTypes() throws Exception {
        Assertions.assertEquals((short)Short.parseShort("1"), (Short)((Short)this.context.getTypeConverter().mandatoryConvertTo(Short.TYPE, (Object)"1")));
        Assertions.assertEquals((int)Integer.parseInt("1"), (Integer)((Integer)this.context.getTypeConverter().mandatoryConvertTo(Integer.TYPE, (Object)"1")));
        Assertions.assertEquals((long)Long.parseLong("1"), (Long)((Long)this.context.getTypeConverter().mandatoryConvertTo(Long.TYPE, (Object)"1")));
        Assertions.assertEquals((float)Float.parseFloat("1.1"), (Float)((Float)this.context.getTypeConverter().mandatoryConvertTo(Float.TYPE, (Object)"1.1")));
        Assertions.assertEquals((double)Double.parseDouble("1.1"), (Double)((Double)this.context.getTypeConverter().mandatoryConvertTo(Double.TYPE, (Object)"1.1")));
        Assertions.assertEquals((char)'a', (Character)((Character)this.context.getTypeConverter().mandatoryConvertTo(Character.TYPE, (Object)"a")));
        Assertions.assertEquals((Object)Boolean.parseBoolean("true"), (Object)this.context.getTypeConverter().mandatoryConvertTo(Boolean.TYPE, (Object)"true"));
    }
}

