/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VetoCamelContextStartTest
extends ContextTestSupport {
    private final LifecycleStrategy veto = new MyVeto();

    @Test
    public void testVetoCamelContextStart() {
        Assertions.assertFalse((boolean)this.context.getStatus().isStarted());
        Assertions.assertTrue((boolean)this.context.getStatus().isStopped());
        Assertions.assertEquals((int)0, (int)this.context.getRoutes().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addLifecycleStrategy(this.veto);
        return context;
    }

    private static class MyVeto
    extends LifecycleStrategySupport {
        private MyVeto() {
        }

        public void onContextStarting(CamelContext context) throws VetoCamelContextStartException {
            throw new VetoCamelContextStartException("Forced", context, false);
        }
    }
}

