/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverterExistsException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.TypeConverterSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TypeConverterRegistryTest {
    @Test
    @Disabled(value="TODO: lookup for base converters")
    public void testDefaultTypeConverterRegistry() {
        DefaultCamelContext ctx = new DefaultCamelContext();
        Assertions.assertNotNull((Object)ctx.getTypeConverterRegistry());
        TypeConverter tc = ctx.getTypeConverterRegistry().lookup(InputStream.class, File.class);
        Assertions.assertNotNull((Object)tc);
    }

    @Test
    public void testAddTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        MyOrder order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((int)123, (int)order.getId());
    }

    @Test
    public void testAddDuplicateTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
    }

    @Test
    public void testAddDuplicateTypeConverterIgnore() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().setTypeConverterExists(TypeConverterExists.Ignore);
        context.getTypeConverterRegistry().setTypeConverterExistsLoggingLevel(LoggingLevel.INFO);
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
    }

    @Test
    public void testAddDuplicateTypeConverterFail() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().setTypeConverterExists(TypeConverterExists.Fail);
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        Assertions.assertThrows(TypeConverterExistsException.class, () -> context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter()), (String)"Should have thrown exception");
    }

    @Test
    public void testRemoveTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        MyOrder order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((int)123, (int)order.getId());
        boolean removed = context.getTypeConverterRegistry().removeTypeConverter(MyOrder.class, String.class);
        Assertions.assertTrue((boolean)removed, (String)"Type converter should be removed");
        order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        Assertions.assertNull((Object)order, (String)"Type converter should be removed");
    }

    private static class MyOrder {
        private int id;

        private MyOrder() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    private static class MyOrderTypeConverter
    extends TypeConverterSupport {
        private MyOrderTypeConverter() {
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
            MyOrder order = new MyOrder();
            order.setId(Integer.parseInt(value.toString()));
            return (T)order;
        }
    }
}

