/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.TypeConverterRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeConverterRegistryStatisticsEnabledNoStreamCachingTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext(false);
        context.setLoadTypeConverters(Boolean.valueOf(this.isLoadTypeConverters()));
        context.setStreamCaching(Boolean.valueOf(false));
        context.setTypeConverterStatisticsEnabled(Boolean.valueOf(true));
        context.build();
        return context;
    }

    @Test
    public void testTypeConverterRegistry() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"3");
        this.template.sendBody("direct:start", (Object)"7");
        this.assertMockEndpointsSatisfied();
        TypeConverterRegistry reg = this.context.getTypeConverterRegistry();
        long failed = reg.getStatistics().getFailedCounter();
        Assertions.assertEquals((int)0, (int)((int)failed));
        long miss = reg.getStatistics().getMissCounter();
        Assertions.assertEquals((int)0, (int)((int)miss));
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"foo"), (String)"Should have thrown exception");
        failed = reg.getStatistics().getFailedCounter();
        Assertions.assertEquals((int)1, (int)((int)failed));
        miss = reg.getStatistics().getMissCounter();
        Assertions.assertEquals((int)0, (int)((int)miss));
        reg.getStatistics().reset();
        failed = reg.getStatistics().getFailedCounter();
        Assertions.assertEquals((int)0, (int)((int)failed));
        miss = reg.getStatistics().getMissCounter();
        Assertions.assertEquals((int)0, (int)((int)miss));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("foo").convertBodyTo(Integer.TYPE)).to("mock:a");
            }
        };
    }
}

