/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.TypeConverterSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeConverterAllowNullTest {
    @Test
    public void testMissThenAddTypeConverter() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getTypeConverterRegistry().addTypeConverter(MyOrder.class, String.class, (TypeConverter)new MyOrderTypeConverter());
        MyOrder order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"0");
        Assertions.assertNull((Object)order);
        order = (MyOrder)context.getTypeConverter().convertTo(MyOrder.class, (Object)"123");
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((int)123, (int)order.getId());
    }

    private static class MyOrder {
        private int id;

        private MyOrder() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }

    private static class MyOrderTypeConverter
    extends TypeConverterSupport {
        private MyOrderTypeConverter() {
        }

        public boolean allowNull() {
            return true;
        }

        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
            if ("0".equals(value)) {
                return null;
            }
            MyOrder order = new MyOrder();
            order.setId(Integer.parseInt(value.toString()));
            return (T)order;
        }
    }
}

