/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TwoRouteSuspendResumeTest
extends ContextTestSupport {
    @Test
    public void testSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        MockEndpoint mockBar = this.getMockEndpoint("mock:bar");
        mockBar.expectedMessageCount(1);
        this.context.getRouteController().suspendRoute("foo");
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> ((SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class)).getQueue().isEmpty());
        Thread.sleep(1000L);
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        mockBar.assertIsSatisfied();
        mock.assertIsSatisfied(1000L);
        Assertions.assertEquals((Object)"Suspended", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("bar").name());
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.getRouteController().resumeRoute("foo");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("foo").name());
        Assertions.assertEquals((Object)"Started", (Object)this.context.getRouteController().getRouteStatus("bar").name());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).to("mock:bar");
            }
        };
    }
}

