/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on GitHub Actions")
public class StopTimeoutRouteTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);

    @Test
    public void testStopTimeout() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        this.context.getRouteController().stopRoute("start", 10L, TimeUnit.MILLISECONDS);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
        this.latch.countDown();
        Assertions.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteController().getRouteStatus("start"));
        Assertions.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteController().getRouteStatus("foo"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("start").process(e -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StopTimeoutRouteTest.this.latch.countDown();
                })).to("mock:foo");
                this.from("direct:foo").routeId("foo").to("mock:foo");
            }
        };
    }
}

