/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.WINDOWS})
public class StopRouteAbortAfterTimeoutTest
extends ContextTestSupport {
    @Test
    public void testStopRouteWithAbortAfterTimeoutTrue() throws Exception {
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        mockEP.setExpectedMessageCount(10);
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        boolean stopRouteResponse = this.context.getRouteController().stopRoute("start", 1L, TimeUnit.SECONDS, true);
        Assertions.assertFalse((boolean)stopRouteResponse, (String)"stopRoute response should be False");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("start").isStarted(), (String)"route should still be started");
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        mockEP.assertIsSatisfied();
    }

    @Test
    public void testStopRouteWithAbortAfterTimeoutFalse() throws Exception {
        MockEndpoint mockEP = this.getMockEndpoint("mock:result");
        for (int i = 0; i < 5; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        boolean stopRouteResponse = this.context.getRouteController().stopRoute("start", 1L, TimeUnit.SECONDS, false);
        Assertions.assertTrue((boolean)stopRouteResponse, (String)"stopRoute response should be True");
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("start").isStopped(), (String)"route should be stopped");
        int before = mockEP.getExchanges().size();
        for (int i = 5; i < 10; ++i) {
            this.template.sendBody("seda:start", (Object)("message-" + i));
        }
        int after = mockEP.getExchanges().size();
        Assertions.assertEquals((int)before, (int)after, (String)"Should not route messages");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StopRouteAbortAfterTimeoutTest.this.context.getShutdownStrategy().setTimeout(3L);
                this.from("seda:start").routeId("start").delay(100L).to("mock:result");
            }
        };
    }
}

