/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.StartupListener;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartupListenerTest
extends ContextTestSupport {
    private final MyStartupListener my = new MyStartupListener();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addStartupListener((StartupListener)this.my);
        return context;
    }

    @Test
    public void testStartupListenerComponent() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.my.getInvoked());
        Assertions.assertFalse((boolean)this.my.isAlreadyStarted());
    }

    @Test
    public void testStartupListenerComponentAlreadyStarted() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        MyStartupListener other = new MyStartupListener();
        this.context.addStartupListener((StartupListener)other);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)other.getInvoked());
        Assertions.assertTrue((boolean)other.isAlreadyStarted());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:foo").routeId("foo").to("mock:result");
            }
        };
    }

    private static class MyStartupListener
    implements StartupListener {
        private int invoked;
        private boolean alreadyStarted;

        private MyStartupListener() {
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) {
            ++this.invoked;
            this.alreadyStarted = alreadyStarted;
            if (alreadyStarted) {
                Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("foo").isStarted());
            } else {
                Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("foo").isStopped());
            }
        }

        public int getInvoked() {
            return this.invoked;
        }

        public boolean isAlreadyStarted() {
            return this.alreadyStarted;
        }
    }
}

