/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.StartupListener;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartupListenerComponentTest
extends ContextTestSupport {
    private MyComponent my;

    @Test
    public void testStartupListenerComponent() throws Exception {
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("foo").isStarted());
        Assertions.assertTrue((boolean)this.context.getRouteController().getRouteStatus("bar").isStarted());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.my.getInvoked());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                StartupListenerComponentTest.this.my = new MyComponent();
                StartupListenerComponentTest.this.context.addComponent("my", (Component)StartupListenerComponentTest.this.my);
                this.from("direct:foo").routeId("foo").to("my:bar");
                this.from("my:bar").routeId("bar").to("mock:result");
            }
        };
    }

    private static class MyComponent
    extends DirectComponent
    implements StartupListener {
        private int invoked;

        private MyComponent() {
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) {
            ++this.invoked;
            Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("foo").isStopped());
            Assertions.assertTrue((boolean)context.getRouteController().getRouteStatus("bar").isStopped());
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

