/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.spi.StartupConditionStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartupConditionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testVetoCamelContextStart() {
        try {
            this.context.start();
            Assertions.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)"Startup condition: MyCondition cannot continue due to: forced error from unit test", (Object)e.getCause().getMessage());
        }
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        StartupConditionStrategy scs = (StartupConditionStrategy)context.getCamelContextExtension().getContextPlugin(StartupConditionStrategy.class);
        scs.setEnabled(true);
        scs.setTimeout(250);
        scs.setOnTimeout("fail");
        scs.addStartupCondition((StartupCondition)new MyCondition());
        return context;
    }

    private static class MyCondition
    implements StartupCondition {
        private MyCondition() {
        }

        public String getFailureMessage() {
            return "forced error from unit test";
        }

        public boolean canContinue(CamelContext camelContext) throws Exception {
            return false;
        }
    }
}

