/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.spi.StartupCondition;
import org.apache.camel.spi.StartupConditionStrategy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartupConditionRegistryStopTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testVetoCamelContextStart() {
        this.context.start();
        Assertions.assertTrue((boolean)this.context.getStatus().isStopped());
        Assertions.assertTrue((boolean)this.context.isVetoStarted());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        StartupConditionStrategy scs = (StartupConditionStrategy)context.getCamelContextExtension().getContextPlugin(StartupConditionStrategy.class);
        scs.setEnabled(true);
        scs.setTimeout(250);
        scs.setOnTimeout("stop");
        context.getRegistry().bind("myCondition", (Object)new MyOtherCondition());
        return context;
    }

    private static class MyOtherCondition
    implements StartupCondition {
        private MyOtherCondition() {
        }

        public String getFailureMessage() {
            return "forced error from unit test";
        }

        public boolean canContinue(CamelContext camelContext) throws Exception {
            return false;
        }
    }
}

