/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartStopAndShutdownRouteTest
extends ContextTestSupport {
    @Test
    public void testStartStopAndShutdownRoute() throws Exception {
        Route myRoute = this.context.getRoute("foo");
        int services = myRoute.getServices().size();
        Assertions.assertTrue((services > 0 ? 1 : 0) != 0);
        this.context.getRouteController().stopRoute("foo");
        Assertions.assertEquals((int)services, (int)myRoute.getServices().size());
        this.context.getRouteController().stopRoute("foo");
        this.context.removeRoute("foo");
        Assertions.assertEquals((int)0, (int)myRoute.getServices().size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("foo").to("mock:foo");
            }
        };
    }
}

